/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.diff;

import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.Config;
import com.netflix.nebula.lint.jgit.util.StringUtils;
import java.text.MessageFormat;

public class DiffConfig {
    public static final Config.SectionParser<DiffConfig> KEY = new Config.SectionParser<DiffConfig>(){

        @Override
        public DiffConfig parse(Config cfg) {
            return new DiffConfig(cfg);
        }
    };
    private final boolean noPrefix;
    private final RenameDetectionType renameDetectionType;
    private final int renameLimit;

    private DiffConfig(Config rc) {
        this.noPrefix = rc.getBoolean("diff", "noprefix", false);
        this.renameDetectionType = DiffConfig.parseRenameDetectionType(rc.getString("diff", null, "renames"));
        this.renameLimit = rc.getInt("diff", "renamelimit", 200);
    }

    public boolean isNoPrefix() {
        return this.noPrefix;
    }

    public boolean isRenameDetectionEnabled() {
        return this.renameDetectionType != RenameDetectionType.FALSE;
    }

    public RenameDetectionType getRenameDetectionType() {
        return this.renameDetectionType;
    }

    public int getRenameLimit() {
        return this.renameLimit;
    }

    private static RenameDetectionType parseRenameDetectionType(String renameString) {
        if (renameString == null) {
            return RenameDetectionType.FALSE;
        }
        if (StringUtils.equalsIgnoreCase("copy", renameString) || StringUtils.equalsIgnoreCase("copies", renameString)) {
            return RenameDetectionType.COPY;
        }
        Boolean renameBoolean = StringUtils.toBooleanOrNull(renameString);
        if (renameBoolean == null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported2, "diff", "renames", renameString));
        }
        if (renameBoolean.booleanValue()) {
            return RenameDetectionType.TRUE;
        }
        return RenameDetectionType.FALSE;
    }

    public static enum RenameDetectionType {
        FALSE,
        TRUE,
        COPY;

    }
}

