/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.dircache;

import com.netflix.nebula.lint.jgit.dircache.BaseDirCacheEditor;
import com.netflix.nebula.lint.jgit.dircache.DirCache;
import com.netflix.nebula.lint.jgit.dircache.DirCacheEntry;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectReader;
import com.netflix.nebula.lint.jgit.treewalk.CanonicalTreeParser;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;

public class DirCacheBuilder
extends BaseDirCacheEditor {
    private boolean sorted;

    protected DirCacheBuilder(DirCache dc, int ecnt) {
        super(dc, ecnt);
    }

    public void add(DirCacheEntry newEntry) {
        if (newEntry.getRawMode() == 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().fileModeNotSetForPath, newEntry.getPathString()));
        }
        this.beforeAdd(newEntry);
        this.fastAdd(newEntry);
    }

    public void keep(int pos, int cnt) {
        this.beforeAdd(this.cache.getEntry(pos));
        this.fastKeep(pos, cnt);
    }

    public void addTree(byte[] pathPrefix, int stage, ObjectReader reader, AnyObjectId tree) throws IOException {
        CanonicalTreeParser p = DirCacheBuilder.createTreeParser(pathPrefix, reader, tree);
        while (!p.eof()) {
            if (DirCacheBuilder.isTree(p)) {
                p = DirCacheBuilder.enterTree(p, reader);
                continue;
            }
            DirCacheEntry first = DirCacheBuilder.toEntry(stage, p);
            this.beforeAdd(first);
            this.fastAdd(first);
            p = p.next();
            break;
        }
        while (!p.eof()) {
            if (DirCacheBuilder.isTree(p)) {
                p = DirCacheBuilder.enterTree(p, reader);
                continue;
            }
            this.fastAdd(DirCacheBuilder.toEntry(stage, p));
            p = p.next();
        }
    }

    private static CanonicalTreeParser createTreeParser(byte[] pathPrefix, ObjectReader reader, AnyObjectId tree) throws IOException {
        return new CanonicalTreeParser(pathPrefix, reader, tree);
    }

    private static boolean isTree(CanonicalTreeParser p) {
        return (p.getEntryRawMode() & 0xF000) == 16384;
    }

    private static CanonicalTreeParser enterTree(CanonicalTreeParser p, ObjectReader reader) throws IOException {
        return (p = p.createSubtreeIterator(reader)).eof() ? p.next() : p;
    }

    private static DirCacheEntry toEntry(int stage, CanonicalTreeParser i) {
        byte[] buf = i.getEntryPathBuffer();
        int len = i.getEntryPathLength();
        byte[] path = new byte[len];
        System.arraycopy(buf, 0, path, 0, len);
        DirCacheEntry e = new DirCacheEntry(path, stage);
        e.setFileMode(i.getEntryRawMode());
        e.setObjectIdFromRaw(i.idBuffer(), i.idOffset());
        return e;
    }

    @Override
    public void finish() {
        if (!this.sorted) {
            this.resort();
        }
        this.replace();
    }

    private void beforeAdd(DirCacheEntry newEntry) {
        if (this.sorted && this.entryCnt > 0) {
            DirCacheEntry lastEntry = this.entries[this.entryCnt - 1];
            int cr = DirCache.cmp(lastEntry, newEntry);
            if (cr > 0) {
                this.sorted = false;
            } else if (cr == 0) {
                int dceStage;
                int peStage = lastEntry.getStage();
                if (peStage == (dceStage = newEntry.getStage())) {
                    throw DirCacheBuilder.bad(newEntry, JGitText.get().duplicateStagesNotAllowed);
                }
                if (peStage == 0 || dceStage == 0) {
                    throw DirCacheBuilder.bad(newEntry, JGitText.get().mixedStagesNotAllowed);
                }
                if (peStage > dceStage) {
                    this.sorted = false;
                }
            }
        }
    }

    private void resort() {
        Arrays.sort(this.entries, 0, this.entryCnt, DirCache.ENT_CMP);
        for (int entryIdx = 1; entryIdx < this.entryCnt; ++entryIdx) {
            int ceStage;
            DirCacheEntry pe = this.entries[entryIdx - 1];
            DirCacheEntry ce = this.entries[entryIdx];
            int cr = DirCache.cmp(pe, ce);
            if (cr != 0) continue;
            int peStage = pe.getStage();
            if (peStage == (ceStage = ce.getStage())) {
                throw DirCacheBuilder.bad(ce, JGitText.get().duplicateStagesNotAllowed);
            }
            if (peStage != 0 && ceStage != 0) continue;
            throw DirCacheBuilder.bad(ce, JGitText.get().mixedStagesNotAllowed);
        }
        this.sorted = true;
    }

    private static IllegalStateException bad(DirCacheEntry a, String msg) {
        return new IllegalStateException(String.format("%s: %d %s", msg, a.getStage(), a.getPathString()));
    }
}

