/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.ketch;

import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.internal.ketch.KetchLeader;
import com.netflix.nebula.lint.jgit.internal.ketch.KetchText;
import com.netflix.nebula.lint.jgit.internal.ketch.Proposal;
import com.netflix.nebula.lint.jgit.transport.PreReceiveHook;
import com.netflix.nebula.lint.jgit.transport.ProgressSpinner;
import com.netflix.nebula.lint.jgit.transport.ReceiveCommand;
import com.netflix.nebula.lint.jgit.transport.ReceivePack;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KetchPreReceive
implements PreReceiveHook {
    private static final Logger log = LoggerFactory.getLogger(KetchPreReceive.class);
    private final KetchLeader leader;

    public KetchPreReceive(KetchLeader leader) {
        this.leader = leader;
    }

    @Override
    public void onPreReceive(ReceivePack rp, Collection<ReceiveCommand> cmds) {
        if ((cmds = ReceiveCommand.filter(cmds, ReceiveCommand.Result.NOT_ATTEMPTED)).isEmpty()) {
            return;
        }
        try {
            Proposal proposal = new Proposal(rp.getRevWalk(), cmds).setPushCertificate(rp.getPushCertificate()).setAuthor(rp.getRefLogIdent()).setMessage("push");
            this.leader.queueProposal(proposal);
            if (proposal.isDone()) {
                return;
            }
            ProgressSpinner spinner = new ProgressSpinner(rp.getMessageOutputStream());
            if (proposal.getState() == Proposal.State.QUEUED) {
                this.waitForQueue(proposal, spinner);
            }
            if (!proposal.isDone()) {
                this.waitForPropose(proposal, spinner);
            }
        }
        catch (IOException | InterruptedException e) {
            String msg = JGitText.get().transactionAborted;
            for (ReceiveCommand cmd : cmds) {
                if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, msg);
            }
            log.error(msg, (Throwable)e);
        }
    }

    private void waitForQueue(Proposal proposal, ProgressSpinner spinner) throws InterruptedException {
        spinner.beginTask(KetchText.get().waitingForQueue, 1L, TimeUnit.SECONDS);
        while (!proposal.awaitStateChange(Proposal.State.QUEUED, 250L, TimeUnit.MILLISECONDS)) {
            spinner.update();
        }
        switch (proposal.getState()) {
            default: {
                spinner.endTask(KetchText.get().starting);
                break;
            }
            case EXECUTED: {
                spinner.endTask(KetchText.get().accepted);
                break;
            }
            case ABORTED: {
                spinner.endTask(KetchText.get().failed);
            }
        }
    }

    private void waitForPropose(Proposal proposal, ProgressSpinner spinner) throws InterruptedException {
        spinner.beginTask(KetchText.get().proposingUpdates, 2L, TimeUnit.SECONDS);
        while (!proposal.await(250L, TimeUnit.MILLISECONDS)) {
            spinner.update();
        }
        spinner.endTask(proposal.getState() == Proposal.State.EXECUTED ? KetchText.get().accepted : KetchText.get().failed);
    }
}

