/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.dfs;

import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsBlock;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsBlockCache;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsInserter;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsObjDatabase;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsOutputStream;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsPackDescription;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsPackFile;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsPackKey;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsText;
import com.netflix.nebula.lint.jgit.internal.storage.file.PackIndex;
import com.netflix.nebula.lint.jgit.internal.storage.file.PackLock;
import com.netflix.nebula.lint.jgit.internal.storage.pack.PackExt;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.Constants;
import com.netflix.nebula.lint.jgit.lib.ProgressMonitor;
import com.netflix.nebula.lint.jgit.transport.PackParser;
import com.netflix.nebula.lint.jgit.transport.PackedObjectInfo;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class DfsPackParser
extends PackParser {
    private final DfsObjDatabase objdb;
    private final DfsInserter objins;
    private final CRC32 crc;
    private final MessageDigest packDigest;
    private int blockSize;
    private long packEnd;
    private byte[] packHash;
    private Deflater def;
    private boolean isEmptyPack;
    private DfsPackDescription packDsc;
    private DfsPackKey packKey;
    private PackIndex packIndex;
    private DfsOutputStream out;
    private byte[] currBuf;
    private long currPos;
    private int currEnd;
    private DfsBlockCache blockCache;
    private long readPos;
    private DfsBlock readBlock;

    protected DfsPackParser(DfsObjDatabase db, DfsInserter ins, InputStream in) {
        super(db, in);
        this.objdb = db;
        this.objins = ins;
        this.crc = new CRC32();
        this.packDigest = Constants.newMessageDigest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackLock parse(ProgressMonitor receiving, ProgressMonitor resolving) throws IOException {
        boolean rollback = true;
        try {
            this.blockCache = DfsBlockCache.getInstance();
            super.parse(receiving, resolving);
            if (this.isEmptyPack) {
                PackLock packLock = null;
                return packLock;
            }
            this.buffer(this.packHash, 0, this.packHash.length);
            if (this.currEnd != 0) {
                this.flushBlock();
            }
            this.out.close();
            this.out = null;
            this.currBuf = null;
            this.readBlock = null;
            this.packDsc.addFileExt(PackExt.PACK);
            this.packDsc.setFileSize(PackExt.PACK, this.packEnd);
            this.writePackIndex();
            this.objdb.commitPack(Collections.singletonList(this.packDsc), null);
            rollback = false;
            DfsPackFile p = this.blockCache.getOrCreate(this.packDsc, this.packKey);
            p.setBlockSize(this.blockSize);
            if (this.packIndex != null) {
                p.setPackIndex(this.packIndex);
            }
            this.objdb.addPack(p);
            PackLock packLock = null;
            return packLock;
        }
        finally {
            this.blockCache = null;
            this.currBuf = null;
            this.readBlock = null;
            if (this.def != null) {
                this.def.end();
                this.def = null;
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
                this.out = null;
            }
            if (rollback && this.packDsc != null) {
                try {
                    this.objdb.rollbackPack(Collections.singletonList(this.packDsc));
                }
                finally {
                    this.packDsc = null;
                }
            }
        }
    }

    public DfsPackDescription getPackDescription() {
        return this.packDsc;
    }

    @Override
    protected void onPackHeader(long objectCount) throws IOException {
        if (objectCount == 0L) {
            this.isEmptyPack = true;
            this.currBuf = new byte[256];
            return;
        }
        this.packDsc = this.objdb.newPack(DfsObjDatabase.PackSource.RECEIVE);
        this.packKey = new DfsPackKey();
        this.out = this.objdb.writeFile(this.packDsc, PackExt.PACK);
        int size = this.out.blockSize();
        if (size <= 0) {
            size = this.blockCache.getBlockSize();
        } else if (size < this.blockCache.getBlockSize()) {
            size = this.blockCache.getBlockSize() / size * size;
        }
        this.blockSize = size;
        this.currBuf = new byte[this.blockSize];
    }

    @Override
    protected void onBeginWholeObject(long streamPosition, int type, long inflatedSize) throws IOException {
        this.crc.reset();
    }

    @Override
    protected void onEndWholeObject(PackedObjectInfo info) throws IOException {
        info.setCRC((int)this.crc.getValue());
    }

    @Override
    protected void onBeginOfsDelta(long streamPosition, long baseStreamPosition, long inflatedSize) throws IOException {
        this.crc.reset();
    }

    @Override
    protected void onBeginRefDelta(long streamPosition, AnyObjectId baseId, long inflatedSize) throws IOException {
        this.crc.reset();
    }

    @Override
    protected PackParser.UnresolvedDelta onEndDelta() throws IOException {
        PackParser.UnresolvedDelta delta = new PackParser.UnresolvedDelta();
        delta.setCRC((int)this.crc.getValue());
        return delta;
    }

    @Override
    protected void onInflatedObjectData(PackedObjectInfo obj, int typeCode, byte[] data) throws IOException {
    }

    @Override
    protected void onObjectHeader(PackParser.Source src, byte[] raw, int pos, int len) throws IOException {
        this.crc.update(raw, pos, len);
    }

    @Override
    protected void onObjectData(PackParser.Source src, byte[] raw, int pos, int len) throws IOException {
        this.crc.update(raw, pos, len);
    }

    @Override
    protected void onStoreStream(byte[] raw, int pos, int len) throws IOException {
        this.buffer(raw, pos, len);
        this.packDigest.update(raw, pos, len);
    }

    private void buffer(byte[] raw, int pos, int len) throws IOException {
        while (0 < len) {
            int n = Math.min(len, this.currBuf.length - this.currEnd);
            if (n == 0) {
                DfsBlock v = this.flushBlock();
                this.currBuf = new byte[this.blockSize];
                this.currEnd = 0;
                this.currPos += (long)v.size();
                continue;
            }
            System.arraycopy(raw, pos, this.currBuf, this.currEnd, n);
            pos += n;
            len -= n;
            this.currEnd += n;
            this.packEnd += (long)n;
        }
    }

    private DfsBlock flushBlock() throws IOException {
        DfsBlock v;
        byte[] buf;
        if (this.isEmptyPack) {
            throw new IOException(DfsText.get().willNotStoreEmptyPack);
        }
        this.out.write(this.currBuf, 0, this.currEnd);
        if (this.currEnd == this.currBuf.length) {
            buf = this.currBuf;
        } else {
            buf = new byte[this.currEnd];
            System.arraycopy(this.currBuf, 0, buf, 0, this.currEnd);
        }
        this.readBlock = v = new DfsBlock(this.packKey, this.currPos, buf);
        this.blockCache.put(v);
        return v;
    }

    @Override
    protected void onPackFooter(byte[] hash) throws IOException {
        this.packHash = hash;
    }

    @Override
    protected PackParser.ObjectTypeAndSize seekDatabase(PackedObjectInfo obj, PackParser.ObjectTypeAndSize info) throws IOException {
        this.readPos = obj.getOffset();
        this.crc.reset();
        return this.readObjectHeader(info);
    }

    @Override
    protected PackParser.ObjectTypeAndSize seekDatabase(PackParser.UnresolvedDelta delta, PackParser.ObjectTypeAndSize info) throws IOException {
        this.readPos = delta.getOffset();
        this.crc.reset();
        return this.readObjectHeader(info);
    }

    @Override
    protected int readDatabase(byte[] dst, int pos, int cnt) throws IOException {
        if (cnt == 0) {
            return 0;
        }
        if (this.currPos <= this.readPos) {
            int p = (int)(this.readPos - this.currPos);
            int n = Math.min(cnt, this.currEnd - p);
            if (n == 0) {
                throw new EOFException();
            }
            System.arraycopy(this.currBuf, p, dst, pos, n);
            this.readPos += (long)n;
            return n;
        }
        if (this.readBlock == null || !this.readBlock.contains(this.packKey, this.readPos)) {
            long start = this.toBlockStart(this.readPos);
            this.readBlock = (DfsBlock)this.blockCache.get(this.packKey, start);
            if (this.readBlock == null) {
                int size = (int)Math.min((long)this.blockSize, this.packEnd - start);
                byte[] buf = new byte[size];
                if (this.read(start, buf, 0, size) != size) {
                    throw new EOFException();
                }
                this.readBlock = new DfsBlock(this.packKey, start, buf);
                this.blockCache.put(this.readBlock);
            }
        }
        int n = this.readBlock.copy(this.readPos, dst, pos, cnt);
        this.readPos += (long)n;
        return n;
    }

    private int read(long pos, byte[] dst, int off, int len) throws IOException {
        int r;
        if (len == 0) {
            return 0;
        }
        int cnt = 0;
        while (0 < len && (r = this.out.read(pos, ByteBuffer.wrap(dst, off, len))) > 0) {
            pos += (long)r;
            off += r;
            len -= r;
            cnt += r;
        }
        return cnt != 0 ? cnt : -1;
    }

    private long toBlockStart(long pos) {
        return pos / (long)this.blockSize * (long)this.blockSize;
    }

    @Override
    protected boolean checkCRC(int oldCRC) {
        return oldCRC == (int)this.crc.getValue();
    }

    @Override
    protected boolean onAppendBase(int typeCode, byte[] data, PackedObjectInfo info) throws IOException {
        info.setOffset(this.packEnd);
        byte[] buf = this.buffer();
        int sz = data.length;
        int len = 0;
        buf[len++] = (byte)(typeCode << 4 | sz & 0xF);
        sz >>>= 4;
        while (sz > 0) {
            int n = len - 1;
            buf[n] = (byte)(buf[n] | 0x80);
            buf[len++] = (byte)(sz & 0x7F);
            sz >>>= 7;
        }
        this.packDigest.update(buf, 0, len);
        this.crc.reset();
        this.crc.update(buf, 0, len);
        this.buffer(buf, 0, len);
        if (this.def == null) {
            this.def = new Deflater(-1, false);
        } else {
            this.def.reset();
        }
        this.def.setInput(data);
        this.def.finish();
        while (!this.def.finished()) {
            len = this.def.deflate(buf);
            this.packDigest.update(buf, 0, len);
            this.crc.update(buf, 0, len);
            this.buffer(buf, 0, len);
        }
        info.setCRC((int)this.crc.getValue());
        return true;
    }

    @Override
    protected void onEndThinPack() throws IOException {
        this.packHash = this.packDigest.digest();
    }

    private void writePackIndex() throws IOException {
        List<PackedObjectInfo> list = this.getSortedObjectList(null);
        this.packIndex = this.objins.writePackIndex(this.packDsc, this.packHash, list);
    }
}

