/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.dfs;

import com.netflix.nebula.lint.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.errors.StoredObjectRepresentationNotAvailableException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DeltaBaseCache;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsBlock;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsCachedPack;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsObjDatabase;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsObjectRepresentation;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsObjectToPack;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsPackFile;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsReaderOptions;
import com.netflix.nebula.lint.jgit.internal.storage.file.BitmapIndexImpl;
import com.netflix.nebula.lint.jgit.internal.storage.file.PackBitmapIndex;
import com.netflix.nebula.lint.jgit.internal.storage.file.PackIndex;
import com.netflix.nebula.lint.jgit.internal.storage.file.PackReverseIndex;
import com.netflix.nebula.lint.jgit.internal.storage.pack.CachedPack;
import com.netflix.nebula.lint.jgit.internal.storage.pack.ObjectReuseAsIs;
import com.netflix.nebula.lint.jgit.internal.storage.pack.ObjectToPack;
import com.netflix.nebula.lint.jgit.internal.storage.pack.PackOutputStream;
import com.netflix.nebula.lint.jgit.internal.storage.pack.PackWriter;
import com.netflix.nebula.lint.jgit.lib.AbbreviatedObjectId;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.AsyncObjectLoaderQueue;
import com.netflix.nebula.lint.jgit.lib.AsyncObjectSizeQueue;
import com.netflix.nebula.lint.jgit.lib.BitmapIndex;
import com.netflix.nebula.lint.jgit.lib.InflaterCache;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectLoader;
import com.netflix.nebula.lint.jgit.lib.ObjectReader;
import com.netflix.nebula.lint.jgit.lib.ProgressMonitor;
import com.netflix.nebula.lint.jgit.util.BlockList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class DfsReader
extends ObjectReader
implements ObjectReuseAsIs {
    private static final int MAX_RESOLVE_MATCHES = 256;
    final byte[] tempId = new byte[20];
    final DfsObjDatabase db;
    private Inflater inf;
    private DfsBlock block;
    private DeltaBaseCache baseCache;
    private DfsPackFile last;
    private boolean avoidUnreachable;
    private static final Comparator<FoundObject<?>> FOUND_OBJECT_SORT = new Comparator<FoundObject<?>>(){

        @Override
        public int compare(FoundObject<?> a, FoundObject<?> b) {
            int cmp = a.packIndex - b.packIndex;
            if (cmp == 0) {
                cmp = Long.signum(a.offset - b.offset);
            }
            return cmp;
        }
    };
    private static final Comparator<DfsObjectToPack> OFFSET_SORT = new Comparator<DfsObjectToPack>(){

        @Override
        public int compare(DfsObjectToPack a, DfsObjectToPack b) {
            return Long.signum(a.getOffset() - b.getOffset());
        }
    };

    DfsReader(DfsObjDatabase db) {
        this.db = db;
    }

    DfsReaderOptions getOptions() {
        return this.db.getReaderOptions();
    }

    DeltaBaseCache getDeltaBaseCache() {
        if (this.baseCache == null) {
            this.baseCache = new DeltaBaseCache(this);
        }
        return this.baseCache;
    }

    int getStreamFileThreshold() {
        return this.getOptions().getStreamFileThreshold();
    }

    @Override
    public ObjectReader newReader() {
        return new DfsReader(this.db);
    }

    @Override
    public void setAvoidUnreachableObjects(boolean avoid) {
        this.avoidUnreachable = avoid;
    }

    @Override
    public BitmapIndex getBitmapIndex() throws IOException {
        for (DfsPackFile pack : this.db.getPacks()) {
            PackBitmapIndex bitmapIndex = pack.getBitmapIndex(this);
            if (bitmapIndex == null) continue;
            return new BitmapIndexImpl(bitmapIndex);
        }
        return null;
    }

    @Override
    public Collection<CachedPack> getCachedPacksAndUpdate(BitmapIndex.BitmapBuilder needBitmap) throws IOException {
        for (DfsPackFile pack : this.db.getPacks()) {
            PackBitmapIndex bitmapIndex = pack.getBitmapIndex(this);
            if (!needBitmap.removeAllOrNone(bitmapIndex)) continue;
            return Collections.singletonList(new DfsCachedPack(pack));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
        if (id.isComplete()) {
            return Collections.singleton(id.toObjectId());
        }
        boolean noGarbage = this.avoidUnreachable;
        HashSet<ObjectId> matches = new HashSet<ObjectId>(4);
        DfsObjDatabase.PackList packList = this.db.getPackList();
        this.resolveImpl(packList, id, noGarbage, matches);
        if (matches.size() < 256 && packList.dirty()) {
            this.resolveImpl(this.db.scanPacks(packList), id, noGarbage, matches);
        }
        return matches;
    }

    private void resolveImpl(DfsObjDatabase.PackList packList, AbbreviatedObjectId id, boolean noGarbage, HashSet<ObjectId> matches) throws IOException {
        for (DfsPackFile pack : packList.packs) {
            if (noGarbage && pack.isGarbage()) continue;
            pack.resolve(this, matches, id, 256);
            if (matches.size() >= 256) break;
        }
    }

    @Override
    public boolean has(AnyObjectId objectId) throws IOException {
        if (this.last != null && this.last.hasObject(this, objectId)) {
            return true;
        }
        boolean noGarbage = this.avoidUnreachable;
        DfsObjDatabase.PackList packList = this.db.getPackList();
        if (this.hasImpl(packList, objectId, noGarbage)) {
            return true;
        }
        if (packList.dirty()) {
            return this.hasImpl(this.db.scanPacks(packList), objectId, noGarbage);
        }
        return false;
    }

    private boolean hasImpl(DfsObjDatabase.PackList packList, AnyObjectId objectId, boolean noGarbage) throws IOException {
        for (DfsPackFile pack : packList.packs) {
            if (pack == this.last || noGarbage && pack.isGarbage() || !pack.hasObject(this, objectId)) continue;
            this.last = pack;
            return true;
        }
        return false;
    }

    @Override
    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        boolean noGarbage;
        ObjectLoader ldr;
        if (this.last != null && (ldr = this.last.get(this, objectId)) != null) {
            return DfsReader.checkType(ldr, objectId, typeHint);
        }
        DfsObjDatabase.PackList packList = this.db.getPackList();
        ldr = this.openImpl(packList, objectId, noGarbage = this.avoidUnreachable);
        if (ldr != null) {
            return DfsReader.checkType(ldr, objectId, typeHint);
        }
        if (packList.dirty() && (ldr = this.openImpl(this.db.scanPacks(packList), objectId, noGarbage)) != null) {
            return DfsReader.checkType(ldr, objectId, typeHint);
        }
        if (typeHint == -1) {
            throw new MissingObjectException(objectId.copy(), JGitText.get().unknownObjectType2);
        }
        throw new MissingObjectException(objectId.copy(), typeHint);
    }

    private static ObjectLoader checkType(ObjectLoader ldr, AnyObjectId id, int typeHint) throws IncorrectObjectTypeException {
        if (typeHint != -1 && ldr.getType() != typeHint) {
            throw new IncorrectObjectTypeException(id.copy(), typeHint);
        }
        return ldr;
    }

    private ObjectLoader openImpl(DfsObjDatabase.PackList packList, AnyObjectId objectId, boolean noGarbage) throws IOException {
        for (DfsPackFile pack : packList.packs) {
            ObjectLoader ldr;
            if (pack == this.last || noGarbage && pack.isGarbage() || (ldr = pack.get(this, objectId)) == null) continue;
            this.last = pack;
            return ldr;
        }
        return null;
    }

    @Override
    public Set<ObjectId> getShallowCommits() {
        return Collections.emptySet();
    }

    private <T extends ObjectId> Iterable<FoundObject<T>> findAll(Iterable<T> objectIds) throws IOException {
        LinkedList<ObjectId> pending = new LinkedList<ObjectId>();
        for (ObjectId id : objectIds) {
            pending.add(id);
        }
        DfsObjDatabase.PackList packList = this.db.getPackList();
        ArrayList<FoundObject<T>> r = new ArrayList<FoundObject<T>>();
        this.findAllImpl(packList, pending, r);
        if (!pending.isEmpty() && packList.dirty()) {
            this.findAllImpl(this.db.scanPacks(packList), pending, r);
        }
        for (ObjectId t : pending) {
            r.add(new FoundObject<ObjectId>(t));
        }
        Collections.sort(r, FOUND_OBJECT_SORT);
        return r;
    }

    private <T extends ObjectId> void findAllImpl(DfsObjDatabase.PackList packList, Collection<T> pending, List<FoundObject<T>> r) {
        DfsPackFile[] packs = packList.packs;
        if (packs.length == 0) {
            return;
        }
        int lastIdx = 0;
        DfsPackFile lastPack = packs[lastIdx];
        boolean noGarbage = this.avoidUnreachable;
        Iterator<T> it = pending.iterator();
        block4: while (it.hasNext()) {
            ObjectId t = (ObjectId)it.next();
            try {
                long p = lastPack.findOffset(this, t);
                if (0L < p) {
                    r.add(new FoundObject<ObjectId>(t, lastIdx, lastPack, p));
                    it.remove();
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (int i = 0; i < packs.length; ++i) {
                if (i == lastIdx) continue;
                DfsPackFile pack = packs[i];
                if (noGarbage && pack.isGarbage()) continue;
                try {
                    long p = pack.findOffset(this, t);
                    if (0L >= p) continue;
                    r.add(new FoundObject<ObjectId>(t, i, pack, p));
                    it.remove();
                    lastIdx = i;
                    lastPack = pack;
                    continue block4;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.last = lastPack;
    }

    @Override
    public <T extends ObjectId> AsyncObjectLoaderQueue<T> open(Iterable<T> objectIds, boolean reportMissing) {
        Iterable<FoundObject<T>> order;
        IOException error = null;
        try {
            order = this.findAll(objectIds);
        }
        catch (IOException e) {
            order = Collections.emptyList();
            error = e;
        }
        final Iterator<FoundObject<T>> idItr = order.iterator();
        final IOException findAllError = error;
        return new AsyncObjectLoaderQueue<T>(){
            private FoundObject<T> cur;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (FoundObject)idItr.next();
                    return true;
                }
                if (findAllError != null) {
                    throw findAllError;
                }
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur.id;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur.id;
            }

            @Override
            public ObjectLoader open() throws IOException {
                if (this.cur.pack == null) {
                    throw new MissingObjectException((ObjectId)this.cur.id, JGitText.get().unknownObjectType2);
                }
                return this.cur.pack.load(DfsReader.this, this.cur.offset);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public void release() {
            }
        };
    }

    @Override
    public <T extends ObjectId> AsyncObjectSizeQueue<T> getObjectSize(Iterable<T> objectIds, boolean reportMissing) {
        Iterable<FoundObject<T>> order;
        IOException error = null;
        try {
            order = this.findAll(objectIds);
        }
        catch (IOException e) {
            order = Collections.emptyList();
            error = e;
        }
        final Iterator<FoundObject<T>> idItr = order.iterator();
        final IOException findAllError = error;
        return new AsyncObjectSizeQueue<T>(){
            private FoundObject<T> cur;
            private long sz;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (FoundObject)idItr.next();
                    if (this.cur.pack == null) {
                        throw new MissingObjectException((ObjectId)this.cur.id, JGitText.get().unknownObjectType2);
                    }
                    this.sz = this.cur.pack.getObjectSize(DfsReader.this, this.cur.offset);
                    return true;
                }
                if (findAllError != null) {
                    throw findAllError;
                }
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur.id;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur.id;
            }

            @Override
            public long getSize() {
                return this.sz;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public void release() {
            }
        };
    }

    @Override
    public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        long sz;
        if (this.last != null && 0L <= (sz = this.last.getObjectSize(this, objectId))) {
            return sz;
        }
        DfsObjDatabase.PackList packList = this.db.getPackList();
        long sz2 = this.getObjectSizeImpl(packList, objectId);
        if (0L <= sz2) {
            return sz2;
        }
        if (packList.dirty() && 0L <= (sz2 = this.getObjectSizeImpl(packList, objectId))) {
            return sz2;
        }
        if (typeHint == -1) {
            throw new MissingObjectException(objectId.copy(), JGitText.get().unknownObjectType2);
        }
        throw new MissingObjectException(objectId.copy(), typeHint);
    }

    private long getObjectSizeImpl(DfsObjDatabase.PackList packList, AnyObjectId objectId) throws IOException {
        for (DfsPackFile pack : packList.packs) {
            long sz;
            if (pack == this.last || 0L > (sz = pack.getObjectSize(this, objectId))) continue;
            this.last = pack;
            return sz;
        }
        return -1L;
    }

    @Override
    public DfsObjectToPack newObjectToPack(AnyObjectId objectId, int type) {
        return new DfsObjectToPack(objectId, type);
    }

    @Override
    public void selectObjectRepresentation(PackWriter packer, ProgressMonitor monitor, Iterable<ObjectToPack> objects) throws IOException, MissingObjectException {
        for (DfsPackFile pack : this.db.getPacks()) {
            List<DfsObjectToPack> tmp = this.findAllFromPack(pack, objects);
            if (tmp.isEmpty()) continue;
            Collections.sort(tmp, OFFSET_SORT);
            PackReverseIndex rev = pack.getReverseIdx(this);
            DfsObjectRepresentation rep = new DfsObjectRepresentation(pack);
            for (DfsObjectToPack otp : tmp) {
                pack.representation(rep, otp.getOffset(), this, rev);
                otp.setOffset(0L);
                packer.select(otp, rep);
                if (otp.isFound()) continue;
                otp.setFound();
                monitor.update(1);
            }
        }
    }

    private List<DfsObjectToPack> findAllFromPack(DfsPackFile pack, Iterable<ObjectToPack> objects) throws IOException {
        BlockList<DfsObjectToPack> tmp = new BlockList<DfsObjectToPack>();
        PackIndex idx = pack.getPackIndex(this);
        for (ObjectToPack otp : objects) {
            long p = idx.findOffset(otp);
            if (0L >= p || pack.isCorrupt(p)) continue;
            otp.setOffset(p);
            tmp.add((DfsObjectToPack)otp);
        }
        return tmp;
    }

    @Override
    public void copyObjectAsIs(PackOutputStream out, ObjectToPack otp, boolean validate) throws IOException, StoredObjectRepresentationNotAvailableException {
        DfsObjectToPack src = (DfsObjectToPack)otp;
        src.pack.copyAsIs(out, src, validate, this);
    }

    @Override
    public void writeObjects(PackOutputStream out, List<ObjectToPack> list) throws IOException {
        for (ObjectToPack otp : list) {
            out.writeObject(otp);
        }
    }

    @Override
    public void copyPackAsIs(PackOutputStream out, CachedPack pack) throws IOException {
        ((DfsCachedPack)pack).copyAsIs(out, this);
    }

    int copy(DfsPackFile pack, long position, byte[] dstbuf, int dstoff, int cnt) throws IOException {
        if (cnt == 0) {
            return 0;
        }
        long length = pack.length;
        if (0L <= length && length <= position) {
            return 0;
        }
        int need = cnt;
        do {
            this.pin(pack, position);
            int r = this.block.copy(position, dstbuf, dstoff, need);
            position += (long)r;
            dstoff += r;
            need -= r;
            if (length >= 0L) continue;
            length = pack.length;
        } while (0 < need && position < length);
        return cnt - need;
    }

    int inflate(DfsPackFile pack, long position, byte[] dstbuf, boolean headerOnly) throws IOException, DataFormatException {
        this.prepareInflater();
        this.pin(pack, position);
        position += (long)this.block.setInput(position, this.inf);
        int dstoff = 0;
        while (true) {
            int n = this.inf.inflate(dstbuf, dstoff, dstbuf.length - dstoff);
            if (this.inf.finished() || headerOnly && (dstoff += n) == dstbuf.length) {
                return dstoff;
            }
            if (this.inf.needsInput()) {
                this.pin(pack, position);
                position += (long)this.block.setInput(position, this.inf);
                continue;
            }
            if (n == 0) break;
        }
        throw new DataFormatException();
    }

    DfsBlock quickCopy(DfsPackFile p, long pos, long cnt) throws IOException {
        this.pin(p, pos);
        if (this.block.contains(p.key, pos + (cnt - 1L))) {
            return this.block;
        }
        return null;
    }

    Inflater inflater() {
        this.prepareInflater();
        return this.inf;
    }

    private void prepareInflater() {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
    }

    void pin(DfsPackFile pack, long position) throws IOException {
        DfsBlock b = this.block;
        if (b == null || !b.contains(pack.key, position)) {
            this.block = null;
            this.block = pack.getOrLoadBlock(position, this);
        }
    }

    void unpin() {
        this.block = null;
    }

    @Override
    public void close() {
        this.last = null;
        this.block = null;
        this.baseCache = null;
        try {
            InflaterCache.release(this.inf);
        }
        finally {
            this.inf = null;
        }
    }

    private static class FoundObject<T extends ObjectId> {
        final T id;
        final DfsPackFile pack;
        final long offset;
        final int packIndex;

        FoundObject(T objectId, int packIdx, DfsPackFile pack, long offset) {
            this.id = objectId;
            this.pack = pack;
            this.offset = offset;
            this.packIndex = packIdx;
        }

        FoundObject(T objectId) {
            this.id = objectId;
            this.pack = null;
            this.offset = 0L;
            this.packIndex = 0;
        }
    }
}

