/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.file;

import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.internal.storage.file.PackIndex;
import com.netflix.nebula.lint.jgit.lib.AbbreviatedObjectId;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.util.IO;
import com.netflix.nebula.lint.jgit.util.NB;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

class PackIndexV2
extends PackIndex {
    private static final long IS_O64 = 0x80000000L;
    private static final int FANOUT = 256;
    private static final int[] NO_INTS = new int[0];
    private static final byte[] NO_BYTES = new byte[0];
    private long objectCnt;
    private final long[] fanoutTable;
    int[][] names;
    byte[][] offset32;
    private byte[][] crc32;
    byte[] offset64;

    PackIndexV2(InputStream fd) throws IOException {
        int k;
        byte[] fanoutRaw = new byte[1024];
        IO.readFully(fd, fanoutRaw, 0, fanoutRaw.length);
        this.fanoutTable = new long[256];
        for (k = 0; k < 256; ++k) {
            this.fanoutTable[k] = NB.decodeUInt32(fanoutRaw, k * 4);
        }
        this.objectCnt = this.fanoutTable[255];
        this.names = new int[256][];
        this.offset32 = new byte[256][];
        this.crc32 = new byte[256][];
        for (k = 0; k < 256; ++k) {
            long bucketCnt = k == 0 ? this.fanoutTable[k] : this.fanoutTable[k] - this.fanoutTable[k - 1];
            if (bucketCnt == 0L) {
                this.names[k] = NO_INTS;
                this.offset32[k] = NO_BYTES;
                this.crc32[k] = NO_BYTES;
                continue;
            }
            if (bucketCnt < 0L) {
                throw new IOException(MessageFormat.format(JGitText.get().indexFileCorruptedNegativeBucketCount, bucketCnt));
            }
            long nameLen = bucketCnt * 20L;
            if (nameLen > 0x7FFFFFF7L) {
                throw new IOException(JGitText.get().indexFileIsTooLargeForJgit);
            }
            int intNameLen = (int)nameLen;
            byte[] raw = new byte[intNameLen];
            int[] bin = new int[intNameLen >>> 2];
            IO.readFully(fd, raw, 0, raw.length);
            for (int i = 0; i < bin.length; ++i) {
                bin[i] = NB.decodeInt32(raw, i << 2);
            }
            this.names[k] = bin;
            this.offset32[k] = new byte[(int)(bucketCnt * 4L)];
            this.crc32[k] = new byte[(int)(bucketCnt * 4L)];
        }
        for (k = 0; k < 256; ++k) {
            IO.readFully(fd, this.crc32[k], 0, this.crc32[k].length);
        }
        int o64cnt = 0;
        for (int k2 = 0; k2 < 256; ++k2) {
            byte[] ofs = this.offset32[k2];
            IO.readFully(fd, ofs, 0, ofs.length);
            for (int p = 0; p < ofs.length; p += 4) {
                if (ofs[p] >= 0) continue;
                ++o64cnt;
            }
        }
        if (o64cnt > 0) {
            this.offset64 = new byte[o64cnt * 8];
            IO.readFully(fd, this.offset64, 0, this.offset64.length);
        } else {
            this.offset64 = NO_BYTES;
        }
        this.packChecksum = new byte[20];
        IO.readFully(fd, this.packChecksum, 0, this.packChecksum.length);
    }

    @Override
    public long getObjectCount() {
        return this.objectCnt;
    }

    @Override
    public long getOffset64Count() {
        return this.offset64.length / 8;
    }

    private int findLevelOne(long nthPosition) {
        int levelOne = Arrays.binarySearch(this.fanoutTable, nthPosition + 1L);
        if (levelOne >= 0) {
            long base = this.fanoutTable[levelOne];
            while (levelOne > 0 && base == this.fanoutTable[levelOne - 1]) {
                --levelOne;
            }
        } else {
            levelOne = -(levelOne + 1);
        }
        return levelOne;
    }

    private int getLevelTwo(long nthPosition, int levelOne) {
        long base = levelOne > 0 ? this.fanoutTable[levelOne - 1] : 0L;
        return (int)(nthPosition - base);
    }

    @Override
    public ObjectId getObjectId(long nthPosition) {
        int levelOne = this.findLevelOne(nthPosition);
        int p = this.getLevelTwo(nthPosition, levelOne);
        int p4 = p << 2;
        return ObjectId.fromRaw(this.names[levelOne], p4 + p);
    }

    @Override
    public long getOffset(long nthPosition) {
        int levelOne = this.findLevelOne(nthPosition);
        int levelTwo = this.getLevelTwo(nthPosition, levelOne);
        return this.getOffset(levelOne, levelTwo);
    }

    @Override
    public long findOffset(AnyObjectId objId) {
        int levelOne = objId.getFirstByte();
        int levelTwo = this.binarySearchLevelTwo(objId, levelOne);
        if (levelTwo == -1) {
            return -1L;
        }
        return this.getOffset(levelOne, levelTwo);
    }

    private long getOffset(int levelOne, int levelTwo) {
        long p = NB.decodeUInt32(this.offset32[levelOne], levelTwo << 2);
        if ((p & 0x80000000L) != 0L) {
            return NB.decodeUInt64(this.offset64, 8 * (int)(p & 0xFFFFFFFF7FFFFFFFL));
        }
        return p;
    }

    @Override
    public long findCRC32(AnyObjectId objId) throws MissingObjectException {
        int levelOne = objId.getFirstByte();
        int levelTwo = this.binarySearchLevelTwo(objId, levelOne);
        if (levelTwo == -1) {
            throw new MissingObjectException(objId.copy(), "unknown");
        }
        return NB.decodeUInt32(this.crc32[levelOne], levelTwo << 2);
    }

    @Override
    public boolean hasCRC32Support() {
        return true;
    }

    @Override
    public Iterator<PackIndex.MutableEntry> iterator() {
        return new EntriesIteratorV2();
    }

    @Override
    public void resolve(Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) throws IOException {
        int[] data = this.names[id.getFirstByte()];
        int max = this.offset32[id.getFirstByte()].length >>> 2;
        int high = max;
        if (high == 0) {
            return;
        }
        int low = 0;
        do {
            int p;
            int cmp;
            if ((cmp = id.prefixCompare(data, PackIndexV2.idOffset(p = low + high >>> 1))) < 0) {
                high = p;
                continue;
            }
            if (cmp == 0) {
                while (0 < p && id.prefixCompare(data, PackIndexV2.idOffset(p - 1)) == 0) {
                    --p;
                }
                while (p < max && id.prefixCompare(data, PackIndexV2.idOffset(p)) == 0) {
                    matches.add(ObjectId.fromRaw(data, PackIndexV2.idOffset(p)));
                    if (matches.size() > matchLimit) break;
                    ++p;
                }
                return;
            }
            low = p + 1;
        } while (low < high);
    }

    private static int idOffset(int p) {
        return (p << 2) + p;
    }

    private int binarySearchLevelTwo(AnyObjectId objId, int levelOne) {
        int[] data = this.names[levelOne];
        int high = this.offset32[levelOne].length >>> 2;
        if (high == 0) {
            return -1;
        }
        int low = 0;
        do {
            int mid;
            int mid4;
            int cmp;
            if ((cmp = objId.compareTo(data, (mid4 = (mid = low + high >>> 1) << 2) + mid)) < 0) {
                high = mid;
                continue;
            }
            if (cmp == 0) {
                return mid;
            }
            low = mid + 1;
        } while (low < high);
        return -1;
    }

    private class EntriesIteratorV2
    extends PackIndex.EntriesIterator {
        int levelOne;
        int levelTwo;

        private EntriesIteratorV2() {
        }

        @Override
        protected PackIndex.MutableEntry initEntry() {
            return new PackIndex.MutableEntry(){

                @Override
                protected void ensureId() {
                    this.idBuffer.fromRaw(PackIndexV2.this.names[EntriesIteratorV2.this.levelOne], EntriesIteratorV2.this.levelTwo - 5);
                }
            };
        }

        @Override
        public PackIndex.MutableEntry next() {
            while (this.levelOne < PackIndexV2.this.names.length) {
                if (this.levelTwo < PackIndexV2.this.names[this.levelOne].length) {
                    int idx = this.levelTwo / 5 * 4;
                    long offset = NB.decodeUInt32(PackIndexV2.this.offset32[this.levelOne], idx);
                    if ((offset & 0x80000000L) != 0L) {
                        idx = 8 * (int)(offset & 0xFFFFFFFF7FFFFFFFL);
                        offset = NB.decodeUInt64(PackIndexV2.this.offset64, idx);
                    }
                    this.entry.offset = offset;
                    this.levelTwo += 5;
                    ++this.returnedNumber;
                    return this.entry;
                }
                this.levelTwo = 0;
                ++this.levelOne;
            }
            throw new NoSuchElementException();
        }
    }
}

