/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.merge;

import com.netflix.nebula.lint.jgit.dircache.DirCache;
import com.netflix.nebula.lint.jgit.dircache.DirCacheBuilder;
import com.netflix.nebula.lint.jgit.dircache.DirCacheEntry;
import com.netflix.nebula.lint.jgit.errors.UnmergedPathException;
import com.netflix.nebula.lint.jgit.lib.FileMode;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectInserter;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.merge.ThreeWayMergeStrategy;
import com.netflix.nebula.lint.jgit.merge.ThreeWayMerger;
import com.netflix.nebula.lint.jgit.treewalk.AbstractTreeIterator;
import com.netflix.nebula.lint.jgit.treewalk.NameConflictTreeWalk;
import java.io.IOException;

public class StrategySimpleTwoWayInCore
extends ThreeWayMergeStrategy {
    protected StrategySimpleTwoWayInCore() {
    }

    @Override
    public String getName() {
        return "simple-two-way-in-core";
    }

    @Override
    public ThreeWayMerger newMerger(Repository db) {
        return new InCoreMerger(db);
    }

    @Override
    public ThreeWayMerger newMerger(Repository db, boolean inCore) {
        return this.newMerger(db);
    }

    private static class InCoreMerger
    extends ThreeWayMerger {
        private static final int T_BASE = 0;
        private static final int T_OURS = 1;
        private static final int T_THEIRS = 2;
        private final NameConflictTreeWalk tw;
        private final DirCache cache;
        private DirCacheBuilder builder;
        private ObjectId resultTree;

        InCoreMerger(Repository local) {
            super(local);
            this.tw = new NameConflictTreeWalk(local, this.reader);
            this.cache = DirCache.newInCore();
        }

        @Override
        protected boolean mergeImpl() throws IOException {
            this.tw.addTree(this.mergeBase());
            this.tw.addTree(this.sourceTrees[0]);
            this.tw.addTree(this.sourceTrees[1]);
            boolean hasConflict = false;
            this.builder = this.cache.builder();
            while (this.tw.next()) {
                int modeT;
                int modeO = this.tw.getRawMode(1);
                if (modeO == (modeT = this.tw.getRawMode(2)) && this.tw.idEqual(1, 2)) {
                    this.add(1, 0);
                    continue;
                }
                int modeB = this.tw.getRawMode(0);
                if (modeB == modeO && this.tw.idEqual(0, 1)) {
                    this.add(2, 0);
                    continue;
                }
                if (modeB == modeT && this.tw.idEqual(0, 2)) {
                    this.add(1, 0);
                    continue;
                }
                if (InCoreMerger.nonTree(modeB)) {
                    this.add(0, 1);
                    hasConflict = true;
                }
                if (InCoreMerger.nonTree(modeO)) {
                    this.add(1, 2);
                    hasConflict = true;
                }
                if (InCoreMerger.nonTree(modeT)) {
                    this.add(2, 3);
                    hasConflict = true;
                }
                if (!this.tw.isSubtree()) continue;
                this.tw.enterSubtree();
            }
            this.builder.finish();
            this.builder = null;
            if (hasConflict) {
                return false;
            }
            try {
                ObjectInserter odi = this.getObjectInserter();
                this.resultTree = this.cache.writeTree(odi);
                odi.flush();
                return true;
            }
            catch (UnmergedPathException upe) {
                this.resultTree = null;
                return false;
            }
        }

        private static boolean nonTree(int mode) {
            return mode != 0 && !FileMode.TREE.equals(mode);
        }

        private void add(int tree, int stage) throws IOException {
            AbstractTreeIterator i = this.getTree(tree);
            if (i != null) {
                if (FileMode.TREE.equals(this.tw.getRawMode(tree))) {
                    this.builder.addTree(this.tw.getRawPath(), stage, this.reader, this.tw.getObjectId(tree));
                } else {
                    DirCacheEntry e = new DirCacheEntry(this.tw.getRawPath(), stage);
                    e.setObjectIdFromRaw(i.idBuffer(), i.idOffset());
                    e.setFileMode(this.tw.getFileMode(tree));
                    this.builder.add(e);
                }
            }
        }

        private AbstractTreeIterator getTree(int tree) {
            return this.tw.getTree(tree, AbstractTreeIterator.class);
        }

        @Override
        public ObjectId getResultTreeId() {
            return this.resultTree;
        }
    }
}

