/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.revplot;

import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.revplot.PlotLane;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;

public class PlotCommit<L extends PlotLane>
extends RevCommit {
    static final PlotCommit[] NO_CHILDREN = new PlotCommit[0];
    static final PlotLane[] NO_LANES = new PlotLane[0];
    static final Ref[] NO_REFS = new Ref[0];
    PlotLane[] forkingOffLanes = NO_LANES;
    PlotLane[] passingLanes = NO_LANES;
    PlotLane[] mergingLanes = NO_LANES;
    PlotLane lane;
    PlotCommit[] children = NO_CHILDREN;
    Ref[] refs = NO_REFS;

    protected PlotCommit(AnyObjectId id) {
        super(id);
    }

    void addForkingOffLane(PlotLane f) {
        this.forkingOffLanes = PlotCommit.addLane(f, this.forkingOffLanes);
    }

    void addPassingLane(PlotLane c) {
        this.passingLanes = PlotCommit.addLane(c, this.passingLanes);
    }

    void addMergingLane(PlotLane m) {
        this.mergingLanes = PlotCommit.addLane(m, this.mergingLanes);
    }

    private static PlotLane[] addLane(PlotLane l, PlotLane[] lanes) {
        int cnt = lanes.length;
        if (cnt == 0) {
            lanes = new PlotLane[]{l};
        } else if (cnt == 1) {
            lanes = new PlotLane[]{lanes[0], l};
        } else {
            PlotLane[] n = new PlotLane[cnt + 1];
            System.arraycopy(lanes, 0, n, 0, cnt);
            n[cnt] = l;
            lanes = n;
        }
        return lanes;
    }

    void addChild(PlotCommit c) {
        int cnt = this.children.length;
        if (cnt == 0) {
            this.children = new PlotCommit[]{c};
        } else if (cnt == 1) {
            if (!c.getId().equals(this.children[0].getId())) {
                this.children = new PlotCommit[]{this.children[0], c};
            }
        } else {
            for (PlotCommit pc : this.children) {
                if (!c.getId().equals(pc.getId())) continue;
                return;
            }
            PlotCommit[] n = new PlotCommit[cnt + 1];
            System.arraycopy(this.children, 0, n, 0, cnt);
            n[cnt] = c;
            this.children = n;
        }
    }

    public final int getChildCount() {
        return this.children.length;
    }

    public final PlotCommit getChild(int nth) {
        return this.children[nth];
    }

    public final boolean isChild(PlotCommit c) {
        for (PlotCommit a : this.children) {
            if (a != c) continue;
            return true;
        }
        return false;
    }

    public final int getRefCount() {
        return this.refs.length;
    }

    public final Ref getRef(int nth) {
        return this.refs[nth];
    }

    public final L getLane() {
        return (L)this.lane;
    }

    @Override
    public void reset() {
        this.forkingOffLanes = NO_LANES;
        this.passingLanes = NO_LANES;
        this.mergingLanes = NO_LANES;
        this.children = NO_CHILDREN;
        this.lane = null;
        super.reset();
    }
}

