/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.revwalk;

import com.netflix.nebula.lint.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.revwalk.BlockRevQueue;
import com.netflix.nebula.lint.jgit.revwalk.Generator;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import java.io.IOException;

class RewriteGenerator
extends Generator {
    private static final int REWRITE = 8;
    private static final int DUPLICATE = 16;
    private final Generator source;

    RewriteGenerator(Generator s) {
        this.source = s;
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        this.source.shareFreeList(q);
    }

    @Override
    int outputType() {
        return this.source.outputType() & 0xFFFFFFFB;
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c = this.source.next();
        if (c == null) {
            return null;
        }
        boolean rewrote = false;
        RevCommit[] pList = c.parents;
        int nParents = pList.length;
        for (int i = 0; i < nParents; ++i) {
            RevCommit oldp = pList[i];
            RevCommit newp = this.rewrite(oldp);
            if (oldp == newp) continue;
            pList[i] = newp;
            rewrote = true;
        }
        if (rewrote) {
            c.parents = this.cleanup(pList);
        }
        return c;
    }

    private RevCommit rewrite(RevCommit p) {
        RevCommit[] pList;
        while ((pList = p.parents).length <= 1) {
            if ((p.flags & 4) != 0) {
                return p;
            }
            if ((p.flags & 8) == 0) {
                return p;
            }
            if (pList.length == 0) {
                return null;
            }
            p = pList[0];
        }
        return p;
    }

    private RevCommit[] cleanup(RevCommit[] oldList) {
        int newCnt = 0;
        for (int o = 0; o < oldList.length; ++o) {
            RevCommit p = oldList[o];
            if (p == null) continue;
            if ((p.flags & 0x10) != 0) {
                oldList[o] = null;
                continue;
            }
            p.flags |= 0x10;
            ++newCnt;
        }
        if (newCnt == oldList.length) {
            for (RevCommit p : oldList) {
                p.flags &= 0xFFFFFFEF;
            }
            return oldList;
        }
        RevCommit[] newList = new RevCommit[newCnt];
        newCnt = 0;
        for (RevCommit p : oldList) {
            if (p == null) continue;
            newList[newCnt++] = p;
            p.flags &= 0xFFFFFFEF;
        }
        return newList;
    }
}

