/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.transport;

import com.netflix.nebula.lint.jgit.api.errors.AbortedByHookException;
import com.netflix.nebula.lint.jgit.errors.NotSupportedException;
import com.netflix.nebula.lint.jgit.errors.TransportException;
import com.netflix.nebula.lint.jgit.hooks.Hooks;
import com.netflix.nebula.lint.jgit.hooks.PrePushHook;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.ObjectChecker;
import com.netflix.nebula.lint.jgit.lib.ProgressMonitor;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.storage.pack.PackConfig;
import com.netflix.nebula.lint.jgit.transport.CredentialsProvider;
import com.netflix.nebula.lint.jgit.transport.FetchConnection;
import com.netflix.nebula.lint.jgit.transport.FetchProcess;
import com.netflix.nebula.lint.jgit.transport.FetchResult;
import com.netflix.nebula.lint.jgit.transport.PushConnection;
import com.netflix.nebula.lint.jgit.transport.PushProcess;
import com.netflix.nebula.lint.jgit.transport.PushResult;
import com.netflix.nebula.lint.jgit.transport.RefSpec;
import com.netflix.nebula.lint.jgit.transport.RemoteConfig;
import com.netflix.nebula.lint.jgit.transport.RemoteRefUpdate;
import com.netflix.nebula.lint.jgit.transport.TagOpt;
import com.netflix.nebula.lint.jgit.transport.TransferConfig;
import com.netflix.nebula.lint.jgit.transport.TransportAmazonS3;
import com.netflix.nebula.lint.jgit.transport.TransportBundleFile;
import com.netflix.nebula.lint.jgit.transport.TransportGitAnon;
import com.netflix.nebula.lint.jgit.transport.TransportGitSsh;
import com.netflix.nebula.lint.jgit.transport.TransportHttp;
import com.netflix.nebula.lint.jgit.transport.TransportLocal;
import com.netflix.nebula.lint.jgit.transport.TransportProtocol;
import com.netflix.nebula.lint.jgit.transport.TransportSftp;
import com.netflix.nebula.lint.jgit.transport.URIish;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class Transport
implements AutoCloseable {
    private static final List<WeakReference<TransportProtocol>> protocols = new CopyOnWriteArrayList<WeakReference<TransportProtocol>>();
    public static final boolean DEFAULT_FETCH_THIN = true;
    public static final boolean DEFAULT_PUSH_THIN = false;
    public static final RefSpec REFSPEC_TAGS;
    public static final RefSpec REFSPEC_PUSH_ALL;
    protected final Repository local;
    protected final URIish uri;
    private String optionUploadPack = "git-upload-pack";
    private List<RefSpec> fetch = Collections.emptyList();
    private TagOpt tagopt = TagOpt.NO_TAGS;
    private boolean fetchThin = true;
    private String optionReceivePack = "git-receive-pack";
    private List<RefSpec> push = Collections.emptyList();
    private boolean pushThin = false;
    private boolean pushAtomic;
    private boolean dryRun;
    private ObjectChecker objectChecker;
    private boolean removeDeletedRefs;
    private int timeout;
    private PackConfig packConfig;
    private CredentialsProvider credentialsProvider;
    private List<String> pushOptions;
    private PrintStream hookOutRedirect;
    private PrePushHook prePush;

    private static void registerByService() {
        ClassLoader ldr = Thread.currentThread().getContextClassLoader();
        if (ldr == null) {
            ldr = Transport.class.getClassLoader();
        }
        Enumeration<URL> catalogs = Transport.catalogs(ldr);
        while (catalogs.hasMoreElements()) {
            Transport.scan(ldr, catalogs.nextElement());
        }
    }

    private static Enumeration<URL> catalogs(ClassLoader ldr) {
        try {
            String prefix = "META-INF/services/";
            String name = prefix + Transport.class.getName();
            return ldr.getResources(name);
        }
        catch (IOException err) {
            return new Vector().elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scan(ClassLoader ldr, URL url) {
        BufferedReader br;
        try {
            InputStream urlIn = url.openStream();
            br = new BufferedReader(new InputStreamReader(urlIn, "UTF-8"));
        }
        catch (IOException err) {
            return;
        }
        try {
            String line;
            while ((line = br.readLine()) != null) {
                int comment;
                if ((line = line.trim()).length() == 0 || (comment = line.indexOf(35)) == 0) continue;
                if (comment != -1) {
                    line = line.substring(0, comment).trim();
                }
                Transport.load(ldr, line);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void load(ClassLoader ldr, String cn) {
        Class<?> clazz;
        try {
            clazz = Class.forName(cn, false, ldr);
        }
        catch (ClassNotFoundException notBuiltin) {
            return;
        }
        for (Field f : clazz.getDeclaredFields()) {
            TransportProtocol proto;
            if ((f.getModifiers() & 8) != 8 || !TransportProtocol.class.isAssignableFrom(f.getType())) continue;
            try {
                proto = (TransportProtocol)f.get(null);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (proto == null) continue;
            Transport.register(proto);
        }
    }

    public static void register(TransportProtocol proto) {
        protocols.add(0, new WeakReference<TransportProtocol>(proto));
    }

    public static void unregister(TransportProtocol proto) {
        for (WeakReference<TransportProtocol> ref : protocols) {
            TransportProtocol refProto = (TransportProtocol)ref.get();
            if (refProto != null && refProto != proto) continue;
            protocols.remove(ref);
        }
    }

    public static List<TransportProtocol> getTransportProtocols() {
        int cnt = protocols.size();
        ArrayList<TransportProtocol> res = new ArrayList<TransportProtocol>(cnt);
        for (WeakReference<TransportProtocol> ref : protocols) {
            TransportProtocol proto = (TransportProtocol)ref.get();
            if (proto != null) {
                res.add(proto);
                continue;
            }
            protocols.remove(ref);
        }
        return Collections.unmodifiableList(res);
    }

    public static Transport open(Repository local, String remote) throws NotSupportedException, URISyntaxException, TransportException {
        return Transport.open(local, remote, Operation.FETCH);
    }

    public static Transport open(Repository local, String remote, Operation op) throws NotSupportedException, URISyntaxException, TransportException {
        if (local != null) {
            RemoteConfig cfg = new RemoteConfig(local.getConfig(), remote);
            if (Transport.doesNotExist(cfg)) {
                return Transport.open(local, new URIish(remote), null);
            }
            return Transport.open(local, cfg, op);
        }
        return Transport.open(new URIish(remote));
    }

    public static List<Transport> openAll(Repository local, String remote) throws NotSupportedException, URISyntaxException, TransportException {
        return Transport.openAll(local, remote, Operation.FETCH);
    }

    public static List<Transport> openAll(Repository local, String remote, Operation op) throws NotSupportedException, URISyntaxException, TransportException {
        RemoteConfig cfg = new RemoteConfig(local.getConfig(), remote);
        if (Transport.doesNotExist(cfg)) {
            ArrayList<Transport> transports = new ArrayList<Transport>(1);
            transports.add(Transport.open(local, new URIish(remote), null));
            return transports;
        }
        return Transport.openAll(local, cfg, op);
    }

    public static Transport open(Repository local, RemoteConfig cfg) throws NotSupportedException, TransportException {
        return Transport.open(local, cfg, Operation.FETCH);
    }

    public static Transport open(Repository local, RemoteConfig cfg, Operation op) throws NotSupportedException, TransportException {
        List<URIish> uris = Transport.getURIs(cfg, op);
        if (uris.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().remoteConfigHasNoURIAssociated, cfg.getName()));
        }
        Transport tn = Transport.open(local, uris.get(0), cfg.getName());
        tn.applyConfig(cfg);
        return tn;
    }

    public static List<Transport> openAll(Repository local, RemoteConfig cfg) throws NotSupportedException, TransportException {
        return Transport.openAll(local, cfg, Operation.FETCH);
    }

    public static List<Transport> openAll(Repository local, RemoteConfig cfg, Operation op) throws NotSupportedException, TransportException {
        List<URIish> uris = Transport.getURIs(cfg, op);
        ArrayList<Transport> transports = new ArrayList<Transport>(uris.size());
        for (URIish uri : uris) {
            Transport tn = Transport.open(local, uri, cfg.getName());
            tn.applyConfig(cfg);
            transports.add(tn);
        }
        return transports;
    }

    private static List<URIish> getURIs(RemoteConfig cfg, Operation op) {
        switch (op) {
            case FETCH: {
                return cfg.getURIs();
            }
            case PUSH: {
                List<URIish> uris = cfg.getPushURIs();
                if (uris.isEmpty()) {
                    uris = cfg.getURIs();
                }
                return uris;
            }
        }
        throw new IllegalArgumentException(op.toString());
    }

    private static boolean doesNotExist(RemoteConfig cfg) {
        return cfg.getURIs().isEmpty() && cfg.getPushURIs().isEmpty();
    }

    public static Transport open(Repository local, URIish uri) throws NotSupportedException, TransportException {
        return Transport.open(local, uri, null);
    }

    public static Transport open(Repository local, URIish uri, String remoteName) throws NotSupportedException, TransportException {
        for (WeakReference<TransportProtocol> ref : protocols) {
            TransportProtocol proto = (TransportProtocol)ref.get();
            if (proto == null) {
                protocols.remove(ref);
                continue;
            }
            if (!proto.canHandle(uri, local, remoteName)) continue;
            Transport tn = proto.open(uri, local, remoteName);
            tn.prePush = Hooks.prePush(local, tn.hookOutRedirect);
            tn.prePush.setRemoteLocation(uri.toString());
            tn.prePush.setRemoteName(remoteName);
            return tn;
        }
        throw new NotSupportedException(MessageFormat.format(JGitText.get().URINotSupported, uri));
    }

    public static Transport open(URIish uri) throws NotSupportedException, TransportException {
        for (WeakReference<TransportProtocol> ref : protocols) {
            TransportProtocol proto = (TransportProtocol)ref.get();
            if (proto == null) {
                protocols.remove(ref);
                continue;
            }
            if (!proto.canHandle(uri, null, null)) continue;
            return proto.open(uri);
        }
        throw new NotSupportedException(MessageFormat.format(JGitText.get().URINotSupported, uri));
    }

    public static Collection<RemoteRefUpdate> findRemoteRefUpdatesFor(Repository db, Collection<RefSpec> specs, Collection<RefSpec> fetchSpecs) throws IOException {
        if (fetchSpecs == null) {
            fetchSpecs = Collections.emptyList();
        }
        LinkedList<RemoteRefUpdate> result = new LinkedList<RemoteRefUpdate>();
        Collection<RefSpec> procRefs = Transport.expandPushWildcardsFor(db, specs);
        for (RefSpec spec : procRefs) {
            String destSpec;
            String srcSpec = spec.getSource();
            Ref srcRef = db.findRef(srcSpec);
            if (srcRef != null) {
                srcSpec = srcRef.getName();
            }
            if ((destSpec = spec.getDestination()) == null) {
                destSpec = srcSpec;
            }
            if (srcRef != null && !destSpec.startsWith("refs/")) {
                String n = srcRef.getName();
                int kindEnd = n.indexOf(47, "refs/".length());
                destSpec = n.substring(0, kindEnd + 1) + destSpec;
            }
            boolean forceUpdate = spec.isForceUpdate();
            String localName = Transport.findTrackingRefName(destSpec, fetchSpecs);
            RemoteRefUpdate rru = new RemoteRefUpdate(db, srcSpec, destSpec, forceUpdate, localName, null);
            result.add(rru);
        }
        return result;
    }

    private static Collection<RefSpec> expandPushWildcardsFor(Repository db, Collection<RefSpec> specs) throws IOException {
        Map<String, Ref> localRefs = db.getRefDatabase().getRefs("");
        HashSet<RefSpec> procRefs = new HashSet<RefSpec>();
        for (RefSpec spec : specs) {
            if (spec.isWildcard()) {
                for (Ref localRef : localRefs.values()) {
                    if (!spec.matchSource(localRef)) continue;
                    procRefs.add(spec.expandFromSource(localRef));
                }
                continue;
            }
            procRefs.add(spec);
        }
        return procRefs;
    }

    private static String findTrackingRefName(String remoteName, Collection<RefSpec> fetchSpecs) {
        for (RefSpec fetchSpec : fetchSpecs) {
            if (!fetchSpec.matchSource(remoteName)) continue;
            if (fetchSpec.isWildcard()) {
                return fetchSpec.expandFromSource(remoteName).getDestination();
            }
            return fetchSpec.getDestination();
        }
        return null;
    }

    protected Transport(Repository local, URIish uri) {
        TransferConfig tc = local.getConfig().get(TransferConfig.KEY);
        this.local = local;
        this.uri = uri;
        this.objectChecker = tc.newObjectChecker();
        this.credentialsProvider = CredentialsProvider.getDefault();
        this.prePush = Hooks.prePush(local, this.hookOutRedirect);
    }

    protected Transport(URIish uri) {
        this.uri = uri;
        this.local = null;
        this.objectChecker = new ObjectChecker();
        this.credentialsProvider = CredentialsProvider.getDefault();
    }

    public URIish getURI() {
        return this.uri;
    }

    public String getOptionUploadPack() {
        return this.optionUploadPack;
    }

    public void setOptionUploadPack(String where) {
        this.optionUploadPack = where != null && where.length() > 0 ? where : "git-upload-pack";
    }

    public TagOpt getTagOpt() {
        return this.tagopt;
    }

    public void setTagOpt(TagOpt option) {
        this.tagopt = option != null ? option : TagOpt.AUTO_FOLLOW;
    }

    public boolean isFetchThin() {
        return this.fetchThin;
    }

    public void setFetchThin(boolean fetchThin) {
        this.fetchThin = fetchThin;
    }

    public boolean isCheckFetchedObjects() {
        return this.getObjectChecker() != null;
    }

    public void setCheckFetchedObjects(boolean check) {
        if (check && this.objectChecker == null) {
            this.setObjectChecker(new ObjectChecker());
        } else if (!check && this.objectChecker != null) {
            this.setObjectChecker(null);
        }
    }

    public ObjectChecker getObjectChecker() {
        return this.objectChecker;
    }

    public void setObjectChecker(ObjectChecker impl) {
        this.objectChecker = impl;
    }

    public String getOptionReceivePack() {
        return this.optionReceivePack;
    }

    public void setOptionReceivePack(String optionReceivePack) {
        this.optionReceivePack = optionReceivePack != null && optionReceivePack.length() > 0 ? optionReceivePack : "git-receive-pack";
    }

    public boolean isPushThin() {
        return this.pushThin;
    }

    public void setPushThin(boolean pushThin) {
        this.pushThin = pushThin;
    }

    public boolean isPushAtomic() {
        return this.pushAtomic;
    }

    public void setPushAtomic(boolean atomic) {
        this.pushAtomic = atomic;
    }

    public boolean isRemoveDeletedRefs() {
        return this.removeDeletedRefs;
    }

    public void setRemoveDeletedRefs(boolean remove) {
        this.removeDeletedRefs = remove;
    }

    public void applyConfig(RemoteConfig cfg) {
        this.setOptionUploadPack(cfg.getUploadPack());
        this.setOptionReceivePack(cfg.getReceivePack());
        this.setTagOpt(cfg.getTagOpt());
        this.fetch = cfg.getFetchRefSpecs();
        this.push = cfg.getPushRefSpecs();
        this.timeout = cfg.getTimeout();
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public PackConfig getPackConfig() {
        if (this.packConfig == null) {
            this.packConfig = new PackConfig(this.local);
        }
        return this.packConfig;
    }

    public void setPackConfig(PackConfig pc) {
        this.packConfig = pc;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public List<String> getPushOptions() {
        return this.pushOptions;
    }

    public void setPushOptions(List<String> pushOptions) {
        this.pushOptions = pushOptions;
    }

    public FetchResult fetch(ProgressMonitor monitor, Collection<RefSpec> toFetch) throws NotSupportedException, TransportException {
        if (toFetch == null || toFetch.isEmpty()) {
            if (this.fetch.isEmpty()) {
                throw new TransportException(JGitText.get().nothingToFetch);
            }
            toFetch = this.fetch;
        } else if (!this.fetch.isEmpty()) {
            ArrayList<RefSpec> tmp = new ArrayList<RefSpec>(toFetch);
            block0: for (RefSpec requested : toFetch) {
                String reqSrc = requested.getSource();
                for (RefSpec configured : this.fetch) {
                    String cfgSrc = configured.getSource();
                    String cfgDst = configured.getDestination();
                    if (!cfgSrc.equals(reqSrc) || cfgDst == null) continue;
                    tmp.add(configured);
                    continue block0;
                }
            }
            toFetch = tmp;
        }
        FetchResult result = new FetchResult();
        new FetchProcess(this, toFetch).execute(monitor, result);
        return result;
    }

    public PushResult push(ProgressMonitor monitor, Collection<RemoteRefUpdate> toPush, OutputStream out) throws NotSupportedException, TransportException {
        if (toPush == null || toPush.isEmpty()) {
            try {
                toPush = this.findRemoteRefUpdatesFor(this.push);
            }
            catch (IOException e) {
                throw new TransportException(MessageFormat.format(JGitText.get().problemWithResolvingPushRefSpecsLocally, e.getMessage()), e);
            }
            if (toPush.isEmpty()) {
                throw new TransportException(JGitText.get().nothingToPush);
            }
        }
        if (this.prePush != null) {
            try {
                this.prePush.setRefs(toPush);
                this.prePush.call();
            }
            catch (AbortedByHookException | IOException e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        PushProcess pushProcess = new PushProcess(this, toPush, out);
        return pushProcess.execute(monitor);
    }

    public PushResult push(ProgressMonitor monitor, Collection<RemoteRefUpdate> toPush) throws NotSupportedException, TransportException {
        return this.push(monitor, toPush, null);
    }

    public Collection<RemoteRefUpdate> findRemoteRefUpdatesFor(Collection<RefSpec> specs) throws IOException {
        return Transport.findRemoteRefUpdatesFor(this.local, specs, this.fetch);
    }

    public abstract FetchConnection openFetch() throws NotSupportedException, TransportException;

    public abstract PushConnection openPush() throws NotSupportedException, TransportException;

    @Override
    public abstract void close();

    static {
        Transport.register(TransportLocal.PROTO_LOCAL);
        Transport.register(TransportBundleFile.PROTO_BUNDLE);
        Transport.register(TransportAmazonS3.PROTO_S3);
        Transport.register(TransportGitAnon.PROTO_GIT);
        Transport.register(TransportSftp.PROTO_SFTP);
        Transport.register(TransportHttp.PROTO_FTP);
        Transport.register(TransportHttp.PROTO_HTTP);
        Transport.register(TransportGitSsh.PROTO_SSH);
        Transport.registerByService();
        REFSPEC_TAGS = new RefSpec("refs/tags/*:refs/tags/*");
        REFSPEC_PUSH_ALL = new RefSpec("refs/heads/*:refs/heads/*");
    }

    public static enum Operation {
        FETCH,
        PUSH;

    }
}

