/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.util;

import com.netflix.nebula.lint.jgit.internal.JGitText;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Arrays;

public class Base64 {
    private static final byte EQUALS_SIGN = 61;
    private static final byte EQUALS_SIGN_DEC = -1;
    private static final byte WHITE_SPACE_DEC = -2;
    private static final byte INVALID_DEC = -3;
    private static final String UTF_8 = "UTF-8";
    private static final byte[] ENC;
    private static final byte[] DEC;

    private Base64() {
    }

    private static void encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset) {
        int inBuff = 0;
        switch (numSigBytes) {
            case 3: {
                inBuff |= source[srcOffset + 2] << 24 >>> 24;
            }
            case 2: {
                inBuff |= source[srcOffset + 1] << 24 >>> 16;
            }
            case 1: {
                inBuff |= source[srcOffset] << 24 >>> 8;
            }
        }
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = ENC[inBuff >>> 18];
                destination[destOffset + 1] = ENC[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ENC[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = ENC[inBuff & 0x3F];
                break;
            }
            case 2: {
                destination[destOffset] = ENC[inBuff >>> 18];
                destination[destOffset + 1] = ENC[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ENC[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = 61;
                break;
            }
            case 1: {
                destination[destOffset] = ENC[inBuff >>> 18];
                destination[destOffset + 1] = ENC[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = 61;
                destination[destOffset + 3] = 61;
            }
        }
    }

    public static String encodeBytes(byte[] source) {
        return Base64.encodeBytes(source, 0, source.length);
    }

    public static String encodeBytes(byte[] source, int off, int len) {
        int len43 = len * 4 / 3;
        byte[] outBuff = new byte[len43 + (len % 3 > 0 ? 4 : 0)];
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        while (d < len2) {
            Base64.encode3to4(source, d + off, 3, outBuff, e);
            d += 3;
            e += 4;
        }
        if (d < len) {
            Base64.encode3to4(source, d + off, len - d, outBuff, e);
            e += 4;
        }
        try {
            return new String(outBuff, 0, e, UTF_8);
        }
        catch (UnsupportedEncodingException uue) {
            return new String(outBuff, 0, e);
        }
    }

    private static int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset) {
        if (source[srcOffset + 2] == 61) {
            int outBuff = (DEC[source[srcOffset]] & 0xFF) << 18 | (DEC[source[srcOffset + 1]] & 0xFF) << 12;
            destination[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (source[srcOffset + 3] == 61) {
            int outBuff = (DEC[source[srcOffset]] & 0xFF) << 18 | (DEC[source[srcOffset + 1]] & 0xFF) << 12 | (DEC[source[srcOffset + 2]] & 0xFF) << 6;
            destination[destOffset] = (byte)(outBuff >>> 16);
            destination[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        int outBuff = (DEC[source[srcOffset]] & 0xFF) << 18 | (DEC[source[srcOffset + 1]] & 0xFF) << 12 | (DEC[source[srcOffset + 2]] & 0xFF) << 6 | DEC[source[srcOffset + 3]] & 0xFF;
        destination[destOffset] = (byte)(outBuff >> 16);
        destination[destOffset + 1] = (byte)(outBuff >> 8);
        destination[destOffset + 2] = (byte)outBuff;
        return 3;
    }

    public static byte[] decode(byte[] source, int off, int len) {
        byte[] outBuff = new byte[len * 3 / 4];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        for (int i = off; i < off + len; ++i) {
            byte sbiCrop = (byte)(source[i] & 0x7F);
            byte sbiDecode = DEC[sbiCrop];
            if (-1 <= sbiDecode) {
                b4[b4Posn++] = sbiCrop;
                if (b4Posn <= 3) continue;
                outBuffPosn += Base64.decode4to3(b4, 0, outBuff, outBuffPosn);
                b4Posn = 0;
                if (sbiCrop != 61) continue;
                break;
            }
            if (sbiDecode == -2) continue;
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().badBase64InputCharacterAt, i, source[i] & 0xFF));
        }
        if (outBuff.length == outBuffPosn) {
            return outBuff;
        }
        byte[] out = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
        return out;
    }

    public static byte[] decode(String s) {
        byte[] bytes;
        try {
            bytes = s.getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException uee) {
            bytes = s.getBytes();
        }
        return Base64.decode(bytes, 0, bytes.length);
    }

    static {
        try {
            ENC = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee.getMessage(), uee);
        }
        DEC = new byte[128];
        Arrays.fill(DEC, (byte)-3);
        for (int i = 0; i < 64; ++i) {
            Base64.DEC[Base64.ENC[i]] = (byte)i;
        }
        Base64.DEC[61] = -1;
        Base64.DEC[9] = -2;
        Base64.DEC[10] = -2;
        Base64.DEC[13] = -2;
        Base64.DEC[32] = -2;
    }
}

