/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.util.io;

import com.netflix.nebula.lint.jgit.util.SystemReader;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ThrowingPrintWriter
extends Writer {
    private final Writer out;
    private final String LF;

    public ThrowingPrintWriter(Writer out) {
        this.out = out;
        this.LF = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return SystemReader.getInstance().getProperty("line.separator");
            }
        });
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void println(String s) throws IOException {
        this.print(s + this.LF);
    }

    public void println() throws IOException {
        this.print(this.LF);
    }

    public void print(char value) throws IOException {
        this.print(String.valueOf(value));
    }

    public void print(int value) throws IOException {
        this.print(String.valueOf(value));
    }

    public void print(long value) throws IOException {
        this.print(String.valueOf(value));
    }

    public void print(short value) throws IOException {
        this.print(String.valueOf(value));
    }

    public void format(String fmt, Object ... args) throws IOException {
        this.print(String.format(fmt, args));
    }

    public void print(Object any) throws IOException {
        this.out.write(String.valueOf(any));
    }
}

