/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.revwalk.filter;

import com.netflix.nebula.lint.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.Constants;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.revwalk.filter.RevFilter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PatternMatchRevFilter
extends RevFilter {
    private final String patternText;
    private final Matcher compiledPattern;

    protected static final String forceToRaw(String patternText) {
        byte[] b = Constants.encode(patternText);
        StringBuilder needle = new StringBuilder(b.length);
        for (int i = 0; i < b.length; ++i) {
            needle.append((char)(b[i] & 0xFF));
        }
        return needle.toString();
    }

    protected PatternMatchRevFilter(String pattern, boolean innerString, boolean rawEncoding, int flags) {
        if (pattern.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        this.patternText = pattern;
        if (innerString) {
            if (!pattern.startsWith("^") && !pattern.startsWith(".*")) {
                pattern = ".*" + pattern;
            }
            if (!pattern.endsWith("$") && !pattern.endsWith(".*")) {
                pattern = pattern + ".*";
            }
        }
        String p = rawEncoding ? PatternMatchRevFilter.forceToRaw(pattern) : pattern;
        this.compiledPattern = Pattern.compile(p, flags).matcher("");
    }

    public String pattern() {
        return this.patternText;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.compiledPattern.reset(this.text(cmit)).matches();
    }

    @Override
    public boolean requiresCommitBody() {
        return true;
    }

    protected abstract CharSequence text(RevCommit var1);

    @Override
    public String toString() {
        return super.toString() + "(\"" + this.patternText + "\")";
    }
}

