/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.InvalidRefNameException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.api.errors.RefNotFoundException;
import com.netflix.nebula.lint.jgit.errors.LockFailedException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.internal.storage.file.ReflogWriter;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.RefUpdate;
import com.netflix.nebula.lint.jgit.lib.ReflogEntry;
import com.netflix.nebula.lint.jgit.lib.ReflogReader;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.List;

public class StashDropCommand
extends GitCommand<ObjectId> {
    private int stashRefEntry;
    private boolean all;

    public StashDropCommand(Repository repo) {
        super(repo);
    }

    public StashDropCommand setStashRef(int stashRef) {
        if (stashRef < 0) {
            throw new IllegalArgumentException();
        }
        this.stashRefEntry = stashRef;
        return this;
    }

    public StashDropCommand setAll(boolean all) {
        this.all = all;
        return this;
    }

    private Ref getRef() throws GitAPIException {
        try {
            return this.repo.exactRef("refs/stash");
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, "refs/stash"), e);
        }
    }

    private RefUpdate createRefUpdate(Ref stashRef) throws IOException {
        RefUpdate update = this.repo.updateRef("refs/stash");
        update.disableRefLog();
        update.setExpectedOldObjectId(stashRef.getObjectId());
        update.setForceUpdate(true);
        return update;
    }

    private void deleteRef(Ref stashRef) {
        try {
            RefUpdate.Result result = this.createRefUpdate(stashRef).delete();
            if (RefUpdate.Result.FORCED != result) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().stashDropDeleteRefFailed, new Object[]{result}));
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, e);
        }
    }

    private void updateRef(Ref stashRef, ObjectId newId) {
        try {
            RefUpdate update = this.createRefUpdate(stashRef);
            update.setNewObjectId(newId);
            RefUpdate.Result result = update.update();
            switch (result) {
                case FORCED: 
                case NEW: 
                case NO_CHANGE: {
                    return;
                }
            }
            throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"refs/stash", newId, result}));
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, e);
        }
    }

    @Override
    public ObjectId call() throws GitAPIException {
        List<ReflogEntry> entries;
        this.checkCallable();
        Ref stashRef = this.getRef();
        if (stashRef == null) {
            return null;
        }
        if (this.all) {
            this.deleteRef(stashRef);
            return null;
        }
        try {
            ReflogReader reader = this.repo.getReflogReader("refs/stash");
            if (reader == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, stashRef));
            }
            entries = reader.getReverseEntries();
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, e);
        }
        if (this.stashRefEntry >= entries.size()) {
            throw new JGitInternalException(JGitText.get().stashDropMissingReflog);
        }
        if (entries.size() == 1) {
            this.deleteRef(stashRef);
            return null;
        }
        ReflogWriter writer = new ReflogWriter(this.repo, true);
        String stashLockRef = ReflogWriter.refLockFor("refs/stash");
        File stashLockFile = writer.logFor(stashLockRef);
        File stashFile = writer.logFor("refs/stash");
        if (stashLockFile.exists()) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, new LockFailedException(stashFile));
        }
        entries.remove(this.stashRefEntry);
        ObjectId entryId = ObjectId.zeroId();
        try {
            for (int i = entries.size() - 1; i >= 0; --i) {
                ReflogEntry entry = entries.get(i);
                writer.log(stashLockRef, entryId, entry.getNewId(), entry.getWho(), entry.getComment());
                entryId = entry.getNewId();
            }
            try {
                FileUtils.rename(stashLockFile, stashFile, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().renameFileFailed, stashLockFile.getPath(), stashFile.getPath()), e);
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashDropFailed, e);
        }
        this.updateRef(stashRef, entryId);
        try {
            Ref newStashRef = this.repo.exactRef("refs/stash");
            return newStashRef != null ? newStashRef.getObjectId() : null;
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, "refs/stash"), e);
        }
    }
}

