/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.merge;

import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.merge.Merger;
import com.netflix.nebula.lint.jgit.merge.StrategyOneSided;
import com.netflix.nebula.lint.jgit.merge.StrategyRecursive;
import com.netflix.nebula.lint.jgit.merge.StrategyResolve;
import com.netflix.nebula.lint.jgit.merge.StrategySimpleTwoWayInCore;
import com.netflix.nebula.lint.jgit.merge.ThreeWayMergeStrategy;
import java.text.MessageFormat;
import java.util.HashMap;

public abstract class MergeStrategy {
    public static final MergeStrategy OURS = new StrategyOneSided("ours", 0);
    public static final MergeStrategy THEIRS = new StrategyOneSided("theirs", 1);
    public static final ThreeWayMergeStrategy SIMPLE_TWO_WAY_IN_CORE = new StrategySimpleTwoWayInCore();
    public static final ThreeWayMergeStrategy RESOLVE = new StrategyResolve();
    public static final ThreeWayMergeStrategy RECURSIVE = new StrategyRecursive();
    private static final HashMap<String, MergeStrategy> STRATEGIES = new HashMap();

    public static void register(MergeStrategy imp) {
        MergeStrategy.register(imp.getName(), imp);
    }

    public static synchronized void register(String name, MergeStrategy imp) {
        if (STRATEGIES.containsKey(name)) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().mergeStrategyAlreadyExistsAsDefault, name));
        }
        STRATEGIES.put(name, imp);
    }

    public static synchronized MergeStrategy get(String name) {
        return STRATEGIES.get(name);
    }

    public static synchronized MergeStrategy[] get() {
        MergeStrategy[] r = new MergeStrategy[STRATEGIES.size()];
        STRATEGIES.values().toArray(r);
        return r;
    }

    public abstract String getName();

    public abstract Merger newMerger(Repository var1);

    public abstract Merger newMerger(Repository var1, boolean var2);

    static {
        MergeStrategy.register(OURS);
        MergeStrategy.register(THEIRS);
        MergeStrategy.register(SIMPLE_TWO_WAY_IN_CORE);
        MergeStrategy.register(RESOLVE);
        MergeStrategy.register(RECURSIVE);
    }
}

