/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.transport;

import com.netflix.nebula.lint.jgit.errors.CorruptObjectException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.errors.TooLargeObjectInPackException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.internal.storage.file.PackLock;
import com.netflix.nebula.lint.jgit.internal.storage.pack.BinaryDelta;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.BatchingProgressMonitor;
import com.netflix.nebula.lint.jgit.lib.Constants;
import com.netflix.nebula.lint.jgit.lib.InflaterCache;
import com.netflix.nebula.lint.jgit.lib.MutableObjectId;
import com.netflix.nebula.lint.jgit.lib.NullProgressMonitor;
import com.netflix.nebula.lint.jgit.lib.ObjectChecker;
import com.netflix.nebula.lint.jgit.lib.ObjectDatabase;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectIdOwnerMap;
import com.netflix.nebula.lint.jgit.lib.ObjectIdSubclassMap;
import com.netflix.nebula.lint.jgit.lib.ObjectLoader;
import com.netflix.nebula.lint.jgit.lib.ObjectReader;
import com.netflix.nebula.lint.jgit.lib.ObjectStream;
import com.netflix.nebula.lint.jgit.lib.ProgressMonitor;
import com.netflix.nebula.lint.jgit.transport.LongMap;
import com.netflix.nebula.lint.jgit.transport.PackedObjectInfo;
import com.netflix.nebula.lint.jgit.util.BlockList;
import com.netflix.nebula.lint.jgit.util.IO;
import com.netflix.nebula.lint.jgit.util.NB;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public abstract class PackParser {
    private static final int BUFFER_SIZE = 8192;
    private final ObjectDatabase objectDatabase;
    private InflaterStream inflater;
    private byte[] tempBuffer;
    private byte[] hdrBuf;
    private final MessageDigest objectDigest;
    private final MutableObjectId tempObjectId;
    private InputStream in;
    byte[] buf;
    private long bBase;
    private int bOffset;
    int bAvail;
    private ObjectChecker objCheck;
    private boolean allowThin;
    private boolean checkObjectCollisions;
    private boolean needBaseObjectIds;
    private boolean checkEofAfterPackFooter;
    private boolean expectDataAfterPackFooter;
    private long objectCount;
    private PackedObjectInfo[] entries;
    private ObjectIdSubclassMap<ObjectId> newObjectIds;
    private int deltaCount;
    private int entryCount;
    private ObjectIdOwnerMap<DeltaChain> baseById;
    private ObjectIdSubclassMap<ObjectId> baseObjectIds;
    private LongMap<UnresolvedDelta> baseByPos;
    private BlockList<PackedObjectInfo> deferredCheckBlobs;
    private MessageDigest packDigest;
    private ObjectReader readCurs;
    private String lockMessage;
    private long maxObjectSizeLimit;

    protected PackParser(ObjectDatabase odb, InputStream src) {
        this.objectDatabase = odb.newCachedDatabase();
        this.in = src;
        this.inflater = new InflaterStream();
        this.readCurs = this.objectDatabase.newReader();
        this.buf = new byte[8192];
        this.tempBuffer = new byte[8192];
        this.hdrBuf = new byte[64];
        this.objectDigest = Constants.newMessageDigest();
        this.tempObjectId = new MutableObjectId();
        this.packDigest = Constants.newMessageDigest();
        this.checkObjectCollisions = true;
    }

    public boolean isAllowThin() {
        return this.allowThin;
    }

    public void setAllowThin(boolean allow) {
        this.allowThin = allow;
    }

    protected boolean isCheckObjectCollisions() {
        return this.checkObjectCollisions;
    }

    protected void setCheckObjectCollisions(boolean check) {
        this.checkObjectCollisions = check;
    }

    public void setNeedNewObjectIds(boolean b) {
        this.newObjectIds = b ? new ObjectIdSubclassMap() : null;
    }

    private boolean needNewObjectIds() {
        return this.newObjectIds != null;
    }

    public void setNeedBaseObjectIds(boolean b) {
        this.needBaseObjectIds = b;
    }

    public boolean isCheckEofAfterPackFooter() {
        return this.checkEofAfterPackFooter;
    }

    public void setCheckEofAfterPackFooter(boolean b) {
        this.checkEofAfterPackFooter = b;
    }

    public boolean isExpectDataAfterPackFooter() {
        return this.expectDataAfterPackFooter;
    }

    public void setExpectDataAfterPackFooter(boolean e) {
        this.expectDataAfterPackFooter = e;
    }

    public ObjectIdSubclassMap<ObjectId> getNewObjectIds() {
        if (this.newObjectIds != null) {
            return this.newObjectIds;
        }
        return new ObjectIdSubclassMap<ObjectId>();
    }

    public ObjectIdSubclassMap<ObjectId> getBaseObjectIds() {
        if (this.baseObjectIds != null) {
            return this.baseObjectIds;
        }
        return new ObjectIdSubclassMap<ObjectId>();
    }

    public void setObjectChecker(ObjectChecker oc) {
        this.objCheck = oc;
    }

    public void setObjectChecking(boolean on) {
        this.setObjectChecker(on ? new ObjectChecker() : null);
    }

    public String getLockMessage() {
        return this.lockMessage;
    }

    public void setLockMessage(String msg) {
        this.lockMessage = msg;
    }

    public void setMaxObjectSizeLimit(long limit) {
        this.maxObjectSizeLimit = limit;
    }

    public int getObjectCount() {
        return this.entryCount;
    }

    public PackedObjectInfo getObject(int nth) {
        return this.entries[nth];
    }

    public List<PackedObjectInfo> getSortedObjectList(Comparator<PackedObjectInfo> cmp) {
        Arrays.sort(this.entries, 0, this.entryCount, cmp);
        List<PackedObjectInfo> list = Arrays.asList(this.entries);
        if (this.entryCount < this.entries.length) {
            list = list.subList(0, this.entryCount);
        }
        return list;
    }

    public long getPackSize() {
        return -1L;
    }

    public final PackLock parse(ProgressMonitor progress) throws IOException {
        return this.parse(progress, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackLock parse(ProgressMonitor receiving, ProgressMonitor resolving) throws IOException {
        if (receiving == null) {
            receiving = NullProgressMonitor.INSTANCE;
        }
        if (resolving == null) {
            resolving = NullProgressMonitor.INSTANCE;
        }
        if (receiving == resolving) {
            receiving.start(2);
        }
        try {
            this.readPackHeader();
            this.entries = new PackedObjectInfo[(int)this.objectCount];
            this.baseById = new ObjectIdOwnerMap();
            this.baseByPos = new LongMap();
            this.deferredCheckBlobs = new BlockList();
            receiving.beginTask(JGitText.get().receivingObjects, (int)this.objectCount);
            try {
                int done = 0;
                while ((long)done < this.objectCount) {
                    this.indexOneObject();
                    receiving.update(1);
                    if (receiving.isCancelled()) {
                        throw new IOException(JGitText.get().downloadCancelled);
                    }
                    ++done;
                }
                this.readPackFooter();
                this.endInput();
            }
            finally {
                receiving.endTask();
            }
            if (!this.deferredCheckBlobs.isEmpty()) {
                this.doDeferredCheckBlobs();
            }
            if (this.deltaCount > 0) {
                if (resolving instanceof BatchingProgressMonitor) {
                    ((BatchingProgressMonitor)resolving).setDelayStart(1000L, TimeUnit.MILLISECONDS);
                }
                resolving.beginTask(JGitText.get().resolvingDeltas, this.deltaCount);
                this.resolveDeltas(resolving);
                if ((long)this.entryCount < this.objectCount) {
                    if (!this.isAllowThin()) {
                        throw new IOException(MessageFormat.format(JGitText.get().packHasUnresolvedDeltas, this.objectCount - (long)this.entryCount));
                    }
                    this.resolveDeltasWithExternalBases(resolving);
                    if ((long)this.entryCount < this.objectCount) {
                        throw new IOException(MessageFormat.format(JGitText.get().packHasUnresolvedDeltas, this.objectCount - (long)this.entryCount));
                    }
                }
                resolving.endTask();
            }
            this.packDigest = null;
            this.baseById = null;
            this.baseByPos = null;
        }
        finally {
            try {
                if (this.readCurs != null) {
                    this.readCurs.close();
                }
            }
            finally {
                this.readCurs = null;
            }
            try {
                this.inflater.release();
            }
            finally {
                this.inflater = null;
            }
        }
        return null;
    }

    private void resolveDeltas(ProgressMonitor progress) throws IOException {
        int last = this.entryCount;
        for (int i = 0; i < last; ++i) {
            this.resolveDeltas(this.entries[i], progress);
            if (!progress.isCancelled()) continue;
            throw new IOException(JGitText.get().downloadCancelledDuringIndexing);
        }
    }

    private void resolveDeltas(PackedObjectInfo oe, ProgressMonitor progress) throws IOException {
        UnresolvedDelta children = this.firstChildOf(oe);
        if (children == null) {
            return;
        }
        DeltaVisit visit = new DeltaVisit();
        visit.nextChild = children;
        ObjectTypeAndSize info = this.openDatabase(oe, new ObjectTypeAndSize());
        switch (info.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                visit.data = this.inflateAndReturn(Source.DATABASE, info.size);
                visit.id = oe;
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, info.type));
            }
        }
        if (!this.checkCRC(oe.getCRC())) {
            throw new IOException(MessageFormat.format(JGitText.get().corruptionDetectedReReadingAt, oe.getOffset()));
        }
        this.resolveDeltas(visit.next(), info.type, info, progress);
    }

    private void resolveDeltas(DeltaVisit visit, int type, ObjectTypeAndSize info, ProgressMonitor progress) throws IOException {
        do {
            progress.update(1);
            info = this.openDatabase(visit.delta, info);
            switch (info.type) {
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, info.type));
                }
            }
            byte[] delta = this.inflateAndReturn(Source.DATABASE, info.size);
            this.checkIfTooLarge(type, BinaryDelta.getResultSize(delta));
            visit.data = BinaryDelta.apply(visit.parent.data, delta);
            delta = null;
            if (!this.checkCRC(visit.delta.crc)) {
                throw new IOException(MessageFormat.format(JGitText.get().corruptionDetectedReReadingAt, visit.delta.position));
            }
            this.objectDigest.update(Constants.encodedTypeString(type));
            this.objectDigest.update((byte)32);
            this.objectDigest.update(Constants.encodeASCII(visit.data.length));
            this.objectDigest.update((byte)0);
            this.objectDigest.update(visit.data);
            this.tempObjectId.fromRaw(this.objectDigest.digest(), 0);
            this.verifySafeObject(this.tempObjectId, type, visit.data);
            PackedObjectInfo oe = this.newInfo(this.tempObjectId, visit.delta, visit.parent.id);
            oe.setOffset(visit.delta.position);
            this.onInflatedObjectData(oe, type, visit.data);
            this.addObjectAndTrack(oe);
            visit.id = oe;
            visit.nextChild = this.firstChildOf(oe);
        } while ((visit = visit.next()) != null);
    }

    private final void checkIfTooLarge(int typeCode, long size) throws IOException {
        if (0L < this.maxObjectSizeLimit && this.maxObjectSizeLimit < size) {
            switch (typeCode) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    throw new TooLargeObjectInPackException(size, this.maxObjectSizeLimit);
                }
                case 6: 
                case 7: {
                    throw new TooLargeObjectInPackException(this.maxObjectSizeLimit);
                }
            }
            throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, typeCode));
        }
    }

    protected ObjectTypeAndSize readObjectHeader(ObjectTypeAndSize info) throws IOException {
        int hdrPtr = 0;
        int c = this.readFrom(Source.DATABASE);
        this.hdrBuf[hdrPtr++] = (byte)c;
        info.type = c >> 4 & 7;
        long sz = c & 0xF;
        int shift = 4;
        while ((c & 0x80) != 0) {
            c = this.readFrom(Source.DATABASE);
            this.hdrBuf[hdrPtr++] = (byte)c;
            sz += (long)(c & 0x7F) << shift;
            shift += 7;
        }
        info.size = sz;
        switch (info.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.onObjectHeader(Source.DATABASE, this.hdrBuf, 0, hdrPtr);
                break;
            }
            case 6: {
                c = this.readFrom(Source.DATABASE);
                this.hdrBuf[hdrPtr++] = (byte)c;
                while ((c & 0x80) != 0) {
                    c = this.readFrom(Source.DATABASE);
                    this.hdrBuf[hdrPtr++] = (byte)c;
                }
                this.onObjectHeader(Source.DATABASE, this.hdrBuf, 0, hdrPtr);
                break;
            }
            case 7: {
                System.arraycopy(this.buf, this.fill(Source.DATABASE, 20), this.hdrBuf, hdrPtr, 20);
                this.use(20);
                this.onObjectHeader(Source.DATABASE, this.hdrBuf, 0, hdrPtr += 20);
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, info.type));
            }
        }
        return info;
    }

    private UnresolvedDelta removeBaseById(AnyObjectId id) {
        DeltaChain d = this.baseById.get(id);
        return d != null ? d.remove() : null;
    }

    private static UnresolvedDelta reverse(UnresolvedDelta c) {
        UnresolvedDelta tail = null;
        while (c != null) {
            UnresolvedDelta n = c.next;
            c.next = tail;
            tail = c;
            c = n;
        }
        return tail;
    }

    private UnresolvedDelta firstChildOf(PackedObjectInfo oe) {
        UnresolvedDelta a = PackParser.reverse(this.removeBaseById(oe));
        UnresolvedDelta b = PackParser.reverse(this.baseByPos.remove(oe.getOffset()));
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        UnresolvedDelta first = null;
        UnresolvedDelta last = null;
        while (a != null || b != null) {
            UnresolvedDelta curr;
            if (b == null || a != null && a.position < b.position) {
                curr = a;
                a = a.next;
            } else {
                curr = b;
                b = b.next;
            }
            if (last != null) {
                last.next = curr;
            } else {
                first = curr;
            }
            last = curr;
            curr.next = null;
        }
        return first;
    }

    private void resolveDeltasWithExternalBases(ProgressMonitor progress) throws IOException {
        this.growEntries(this.baseById.size());
        if (this.needBaseObjectIds) {
            this.baseObjectIds = new ObjectIdSubclassMap();
        }
        ArrayList<DeltaChain> missing = new ArrayList<DeltaChain>(64);
        for (DeltaChain baseId : this.baseById) {
            ObjectLoader ldr;
            if (baseId.head == null) continue;
            if (this.needBaseObjectIds) {
                this.baseObjectIds.add(baseId);
            }
            try {
                ldr = this.readCurs.open(baseId);
            }
            catch (MissingObjectException notFound) {
                missing.add(baseId);
                continue;
            }
            DeltaVisit visit = new DeltaVisit();
            visit.data = ldr.getCachedBytes(Integer.MAX_VALUE);
            visit.id = baseId;
            int typeCode = ldr.getType();
            PackedObjectInfo oe = this.newInfo(baseId, null, null);
            if (this.onAppendBase(typeCode, visit.data, oe)) {
                this.entries[this.entryCount++] = oe;
            }
            visit.nextChild = this.firstChildOf(oe);
            this.resolveDeltas(visit.next(), typeCode, new ObjectTypeAndSize(), progress);
            if (!progress.isCancelled()) continue;
            throw new IOException(JGitText.get().downloadCancelledDuringIndexing);
        }
        for (DeltaChain base : missing) {
            if (base.head == null) continue;
            throw new MissingObjectException((ObjectId)base, "delta base");
        }
        this.onEndThinPack();
    }

    private void growEntries(int extraObjects) {
        PackedObjectInfo[] ne = new PackedObjectInfo[(int)this.objectCount + extraObjects];
        System.arraycopy(this.entries, 0, ne, 0, this.entryCount);
        this.entries = ne;
    }

    private void readPackHeader() throws IOException {
        if (this.expectDataAfterPackFooter) {
            if (!this.in.markSupported()) {
                throw new IOException(JGitText.get().inputStreamMustSupportMark);
            }
            this.in.mark(this.buf.length);
        }
        int hdrln = Constants.PACK_SIGNATURE.length + 4 + 4;
        int p = this.fill(Source.INPUT, hdrln);
        for (int k = 0; k < Constants.PACK_SIGNATURE.length; ++k) {
            if (this.buf[p + k] == Constants.PACK_SIGNATURE[k]) continue;
            throw new IOException(JGitText.get().notAPACKFile);
        }
        long vers = NB.decodeUInt32(this.buf, p + 4);
        if (vers != 2L && vers != 3L) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedPackVersion, vers));
        }
        this.objectCount = NB.decodeUInt32(this.buf, p + 8);
        this.use(hdrln);
        this.onPackHeader(this.objectCount);
    }

    private void readPackFooter() throws IOException {
        this.sync();
        byte[] actHash = this.packDigest.digest();
        int c = this.fill(Source.INPUT, 20);
        byte[] srcHash = new byte[20];
        System.arraycopy(this.buf, c, srcHash, 0, 20);
        this.use(20);
        if (this.bAvail != 0 && !this.expectDataAfterPackFooter) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().expectedEOFReceived, "\\x" + Integer.toHexString(this.buf[this.bOffset] & 0xFF)));
        }
        if (this.isCheckEofAfterPackFooter()) {
            int eof = this.in.read();
            if (0 <= eof) {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().expectedEOFReceived, "\\x" + Integer.toHexString(eof)));
            }
        } else if (this.bAvail > 0 && this.expectDataAfterPackFooter) {
            this.in.reset();
            IO.skipFully(this.in, this.bOffset);
        }
        if (!Arrays.equals(actHash, srcHash)) {
            throw new CorruptObjectException(JGitText.get().corruptObjectPackfileChecksumIncorrect);
        }
        this.onPackFooter(srcHash);
    }

    private void endInput() {
        this.in = null;
    }

    private void indexOneObject() throws IOException {
        long streamPosition = this.streamPosition();
        int hdrPtr = 0;
        int c = this.readFrom(Source.INPUT);
        this.hdrBuf[hdrPtr++] = (byte)c;
        int typeCode = c >> 4 & 7;
        long sz = c & 0xF;
        int shift = 4;
        while ((c & 0x80) != 0) {
            c = this.readFrom(Source.INPUT);
            this.hdrBuf[hdrPtr++] = (byte)c;
            sz += (long)(c & 0x7F) << shift;
            shift += 7;
        }
        this.checkIfTooLarge(typeCode, sz);
        switch (typeCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.onBeginWholeObject(streamPosition, typeCode, sz);
                this.onObjectHeader(Source.INPUT, this.hdrBuf, 0, hdrPtr);
                this.whole(streamPosition, typeCode, sz);
                break;
            }
            case 6: {
                c = this.readFrom(Source.INPUT);
                this.hdrBuf[hdrPtr++] = (byte)c;
                long ofs = c & 0x7F;
                while ((c & 0x80) != 0) {
                    ++ofs;
                    c = this.readFrom(Source.INPUT);
                    this.hdrBuf[hdrPtr++] = (byte)c;
                    ofs <<= 7;
                    ofs += (long)(c & 0x7F);
                }
                long base = streamPosition - ofs;
                this.onBeginOfsDelta(streamPosition, base, sz);
                this.onObjectHeader(Source.INPUT, this.hdrBuf, 0, hdrPtr);
                this.inflateAndSkip(Source.INPUT, sz);
                UnresolvedDelta n = this.onEndDelta();
                n.position = streamPosition;
                n.next = this.baseByPos.put(base, n);
                ++this.deltaCount;
                break;
            }
            case 7: {
                c = this.fill(Source.INPUT, 20);
                ObjectId base = ObjectId.fromRaw(this.buf, c);
                System.arraycopy(this.buf, c, this.hdrBuf, hdrPtr, 20);
                hdrPtr += 20;
                this.use(20);
                DeltaChain r = this.baseById.get(base);
                if (r == null) {
                    r = new DeltaChain(base);
                    this.baseById.add(r);
                }
                this.onBeginRefDelta(streamPosition, base, sz);
                this.onObjectHeader(Source.INPUT, this.hdrBuf, 0, hdrPtr);
                this.inflateAndSkip(Source.INPUT, sz);
                UnresolvedDelta n = this.onEndDelta();
                n.position = streamPosition;
                r.add(n);
                ++this.deltaCount;
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, typeCode));
            }
        }
    }

    private void whole(long pos, int type, long sz) throws IOException {
        byte[] data;
        this.objectDigest.update(Constants.encodedTypeString(type));
        this.objectDigest.update((byte)32);
        this.objectDigest.update(Constants.encodeASCII(sz));
        this.objectDigest.update((byte)0);
        boolean checkContentLater = false;
        if (type == 3) {
            int r;
            byte[] readBuffer = this.buffer();
            InputStream inf = this.inflate(Source.INPUT, sz);
            for (long cnt = 0L; cnt < sz && (r = inf.read(readBuffer)) > 0; cnt += (long)r) {
                this.objectDigest.update(readBuffer, 0, r);
            }
            inf.close();
            this.tempObjectId.fromRaw(this.objectDigest.digest(), 0);
            checkContentLater = this.isCheckObjectCollisions() && this.readCurs.has(this.tempObjectId);
            data = null;
        } else {
            data = this.inflateAndReturn(Source.INPUT, sz);
            this.objectDigest.update(data);
            this.tempObjectId.fromRaw(this.objectDigest.digest(), 0);
            this.verifySafeObject(this.tempObjectId, type, data);
        }
        PackedObjectInfo obj = this.newInfo(this.tempObjectId, null, null);
        obj.setOffset(pos);
        this.onEndWholeObject(obj);
        if (data != null) {
            this.onInflatedObjectData(obj, type, data);
        }
        this.addObjectAndTrack(obj);
        if (checkContentLater) {
            this.deferredCheckBlobs.add(obj);
        }
    }

    private void verifySafeObject(AnyObjectId id, int type, byte[] data) throws IOException {
        if (this.objCheck != null) {
            try {
                this.objCheck.check(id, type, data);
            }
            catch (CorruptObjectException e) {
                if (e.getErrorType() != null) {
                    throw e;
                }
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().invalidObject, Constants.typeString(type), this.readCurs.abbreviate(id, 10).name(), e.getMessage()), e);
            }
        }
        if (this.isCheckObjectCollisions()) {
            try {
                ObjectLoader ldr = this.readCurs.open(id, type);
                byte[] existingData = ldr.getCachedBytes(data.length);
                if (!Arrays.equals(data, existingData)) {
                    throw new IOException(MessageFormat.format(JGitText.get().collisionOn, id.name()));
                }
            }
            catch (MissingObjectException missingObjectException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeferredCheckBlobs() throws IOException {
        byte[] readBuffer = this.buffer();
        byte[] curBuffer = new byte[readBuffer.length];
        ObjectTypeAndSize info = new ObjectTypeAndSize();
        for (PackedObjectInfo obj : this.deferredCheckBlobs) {
            info = this.openDatabase(obj, info);
            if (info.type != 3) {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, info.type));
            }
            try (ObjectStream cur = this.readCurs.open(obj, info.type).openStream();){
                int n;
                long sz;
                if (cur.getSize() != sz) {
                    throw new IOException(MessageFormat.format(JGitText.get().collisionOn, obj.name()));
                }
                InputStream pck = this.inflate(Source.DATABASE, sz);
                for (sz = info.size; 0L < sz; sz -= (long)n) {
                    n = (int)Math.min((long)readBuffer.length, sz);
                    IO.readFully(cur, curBuffer, 0, n);
                    IO.readFully(pck, readBuffer, 0, n);
                    for (int i = 0; i < n; ++i) {
                        if (curBuffer[i] == readBuffer[i]) continue;
                        throw new IOException(MessageFormat.format(JGitText.get().collisionOn, obj.name()));
                    }
                }
                pck.close();
            }
        }
    }

    private long streamPosition() {
        return this.bBase + (long)this.bOffset;
    }

    private ObjectTypeAndSize openDatabase(PackedObjectInfo obj, ObjectTypeAndSize info) throws IOException {
        this.bOffset = 0;
        this.bAvail = 0;
        return this.seekDatabase(obj, info);
    }

    private ObjectTypeAndSize openDatabase(UnresolvedDelta delta, ObjectTypeAndSize info) throws IOException {
        this.bOffset = 0;
        this.bAvail = 0;
        return this.seekDatabase(delta, info);
    }

    private int readFrom(Source src) throws IOException {
        if (this.bAvail == 0) {
            this.fill(src, 1);
        }
        --this.bAvail;
        return this.buf[this.bOffset++] & 0xFF;
    }

    void use(int cnt) {
        this.bOffset += cnt;
        this.bAvail -= cnt;
    }

    int fill(Source src, int need) throws IOException {
        while (this.bAvail < need) {
            int next = this.bOffset + this.bAvail;
            int free = this.buf.length - next;
            if (free + this.bAvail < need) {
                switch (src) {
                    case INPUT: {
                        this.sync();
                        break;
                    }
                    case DATABASE: {
                        if (this.bAvail > 0) {
                            System.arraycopy(this.buf, this.bOffset, this.buf, 0, this.bAvail);
                        }
                        this.bOffset = 0;
                    }
                }
                next = this.bAvail;
                free = this.buf.length - next;
            }
            switch (src) {
                case INPUT: {
                    next = this.in.read(this.buf, next, free);
                    break;
                }
                case DATABASE: {
                    next = this.readDatabase(this.buf, next, free);
                }
            }
            if (next <= 0) {
                throw new EOFException(JGitText.get().packfileIsTruncatedNoParam);
            }
            this.bAvail += next;
        }
        return this.bOffset;
    }

    private void sync() throws IOException {
        this.packDigest.update(this.buf, 0, this.bOffset);
        this.onStoreStream(this.buf, 0, this.bOffset);
        if (this.expectDataAfterPackFooter) {
            if (this.bAvail > 0) {
                this.in.reset();
                IO.skipFully(this.in, this.bOffset);
                this.bAvail = 0;
            }
            this.in.mark(this.buf.length);
        } else if (this.bAvail > 0) {
            System.arraycopy(this.buf, this.bOffset, this.buf, 0, this.bAvail);
        }
        this.bBase += (long)this.bOffset;
        this.bOffset = 0;
    }

    protected byte[] buffer() {
        return this.tempBuffer;
    }

    protected PackedObjectInfo newInfo(AnyObjectId id, UnresolvedDelta delta, ObjectId deltaBase) {
        PackedObjectInfo oe = new PackedObjectInfo(id);
        if (delta != null) {
            oe.setCRC(delta.crc);
        }
        return oe;
    }

    protected abstract void onStoreStream(byte[] var1, int var2, int var3) throws IOException;

    protected abstract void onObjectHeader(Source var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract void onObjectData(Source var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract void onInflatedObjectData(PackedObjectInfo var1, int var2, byte[] var3) throws IOException;

    protected abstract void onPackHeader(long var1) throws IOException;

    protected abstract void onPackFooter(byte[] var1) throws IOException;

    protected abstract boolean onAppendBase(int var1, byte[] var2, PackedObjectInfo var3) throws IOException;

    protected abstract void onEndThinPack() throws IOException;

    protected abstract ObjectTypeAndSize seekDatabase(PackedObjectInfo var1, ObjectTypeAndSize var2) throws IOException;

    protected abstract ObjectTypeAndSize seekDatabase(UnresolvedDelta var1, ObjectTypeAndSize var2) throws IOException;

    protected abstract int readDatabase(byte[] var1, int var2, int var3) throws IOException;

    protected abstract boolean checkCRC(int var1);

    protected abstract void onBeginWholeObject(long var1, int var3, long var4) throws IOException;

    protected abstract void onEndWholeObject(PackedObjectInfo var1) throws IOException;

    protected abstract void onBeginOfsDelta(long var1, long var3, long var5) throws IOException;

    protected abstract void onBeginRefDelta(long var1, AnyObjectId var3, long var4) throws IOException;

    protected UnresolvedDelta onEndDelta() throws IOException {
        return new UnresolvedDelta();
    }

    private void inflateAndSkip(Source src, long inflatedSize) throws IOException {
        InputStream inf = this.inflate(src, inflatedSize);
        IO.skipFully(inf, inflatedSize);
        inf.close();
    }

    private byte[] inflateAndReturn(Source src, long inflatedSize) throws IOException {
        byte[] dst = new byte[(int)inflatedSize];
        InputStream inf = this.inflate(src, inflatedSize);
        IO.readFully(inf, dst, 0, dst.length);
        inf.close();
        return dst;
    }

    private InputStream inflate(Source src, long inflatedSize) throws IOException {
        this.inflater.open(src, inflatedSize);
        return this.inflater;
    }

    private void addObjectAndTrack(PackedObjectInfo oe) {
        this.entries[this.entryCount++] = oe;
        if (this.needNewObjectIds()) {
            this.newObjectIds.add(oe);
        }
    }

    private static class DeltaChain
    extends ObjectIdOwnerMap.Entry {
        UnresolvedDelta head;

        DeltaChain(AnyObjectId id) {
            super(id);
        }

        UnresolvedDelta remove() {
            UnresolvedDelta r = this.head;
            if (r != null) {
                this.head = null;
            }
            return r;
        }

        void add(UnresolvedDelta d) {
            d.next = this.head;
            this.head = d;
        }
    }

    private static class DeltaVisit {
        final UnresolvedDelta delta;
        ObjectId id;
        byte[] data;
        DeltaVisit parent;
        UnresolvedDelta nextChild;

        DeltaVisit() {
            this.delta = null;
        }

        DeltaVisit(DeltaVisit parent) {
            this.parent = parent;
            this.delta = parent.nextChild;
            parent.nextChild = this.delta.next;
        }

        DeltaVisit next() {
            if (this.parent != null && this.parent.nextChild == null) {
                this.parent.data = null;
                this.parent = this.parent.parent;
            }
            if (this.nextChild != null) {
                return new DeltaVisit(this);
            }
            if (this.parent != null) {
                return new DeltaVisit(this.parent);
            }
            return null;
        }
    }

    private class InflaterStream
    extends InputStream {
        private final Inflater inf = InflaterCache.get();
        private final byte[] skipBuffer = new byte[512];
        private Source src;
        private long expectedSize;
        private long actualSize;
        private int p;

        InflaterStream() {
        }

        void release() {
            this.inf.reset();
            InflaterCache.release(this.inf);
        }

        void open(Source source, long inflatedSize) throws IOException {
            this.src = source;
            this.expectedSize = inflatedSize;
            this.actualSize = 0L;
            this.p = PackParser.this.fill(this.src, 1);
            this.inf.setInput(PackParser.this.buf, this.p, PackParser.this.bAvail);
        }

        @Override
        public long skip(long toSkip) throws IOException {
            int cnt;
            long n;
            int r;
            for (n = 0L; n < toSkip && (r = this.read(this.skipBuffer, 0, cnt = (int)Math.min((long)this.skipBuffer.length, toSkip - n))) > 0; n += (long)r) {
            }
            return n;
        }

        @Override
        public int read() throws IOException {
            int n = this.read(this.skipBuffer, 0, 1);
            return n == 1 ? this.skipBuffer[0] & 0xFF : -1;
        }

        @Override
        public int read(byte[] dst, int pos, int cnt) throws IOException {
            try {
                int n;
                int r;
                for (n = 0; n < cnt; n += r) {
                    r = this.inf.inflate(dst, pos + n, cnt - n);
                    if (this.inf.finished()) break;
                    if (!this.inf.needsInput()) continue;
                    PackParser.this.onObjectData(this.src, PackParser.this.buf, this.p, PackParser.this.bAvail);
                    PackParser.this.use(PackParser.this.bAvail);
                    this.p = PackParser.this.fill(this.src, 1);
                    this.inf.setInput(PackParser.this.buf, this.p, PackParser.this.bAvail);
                }
                this.actualSize += (long)n;
                return 0 < n ? n : -1;
            }
            catch (DataFormatException dfe) {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().packfileCorruptionDetected, dfe.getMessage()));
            }
        }

        @Override
        public void close() throws IOException {
            if (this.read(this.skipBuffer) != -1 || this.actualSize != this.expectedSize) {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().packfileCorruptionDetected, JGitText.get().wrongDecompressedLength));
            }
            int used = PackParser.this.bAvail - this.inf.getRemaining();
            if (0 < used) {
                PackParser.this.onObjectData(this.src, PackParser.this.buf, this.p, used);
                PackParser.this.use(used);
            }
            this.inf.reset();
        }
    }

    public static class ObjectTypeAndSize {
        public int type;
        public long size;
    }

    public static enum Source {
        INPUT,
        DATABASE;

    }

    public static class UnresolvedDelta {
        long position;
        int crc;
        UnresolvedDelta next;

        public long getOffset() {
            return this.position;
        }

        public int getCRC() {
            return this.crc;
        }

        public void setCRC(int crc32) {
            this.crc = crc32;
        }
    }
}

