/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.core;

import com.netflix.nebula.lint.jdt.core.Signature;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.core.runtime.IProgressMonitor;

public final class CompletionProposal
extends InternalCompletionProposal {
    private boolean updateCompletion = false;
    public static final int ANONYMOUS_CLASS_DECLARATION = 1;
    public static final int FIELD_REF = 2;
    public static final int KEYWORD = 3;
    public static final int LABEL_REF = 4;
    public static final int LOCAL_VARIABLE_REF = 5;
    public static final int METHOD_REF = 6;
    public static final int METHOD_DECLARATION = 7;
    public static final int PACKAGE_REF = 8;
    public static final int TYPE_REF = 9;
    public static final int VARIABLE_DECLARATION = 10;
    public static final int POTENTIAL_METHOD_DECLARATION = 11;
    public static final int METHOD_NAME_REFERENCE = 12;
    public static final int ANNOTATION_ATTRIBUTE_REF = 13;
    protected static final int FIRST_KIND = 1;
    protected static final int LAST_KIND = 13;
    private int completionKind;
    private int completionLocation;
    private int tokenStart = 0;
    private int tokenEnd = 0;
    private char[] completion = CharOperation.NO_CHAR;
    private int replaceStart = 0;
    private int replaceEnd = 0;
    private int relevance = 1;
    private char[] declarationSignature = null;
    private char[] declarationKey = null;
    private char[] name = null;
    private char[] signature = null;
    private char[] key = null;
    private int flags = 0;
    private char[][] parameterNames = null;
    private boolean parameterNamesComputed = false;

    public static CompletionProposal create(int kind, int completionOffset) {
        return new CompletionProposal(kind, completionOffset);
    }

    CompletionProposal(int kind, int completionLocation) {
        if (kind < 1 || kind > 13) {
            throw new IllegalArgumentException();
        }
        if (this.completion == null || completionLocation < 0) {
            throw new IllegalArgumentException();
        }
        this.completionKind = kind;
        this.completionLocation = completionLocation;
    }

    public int getKind() {
        return this.completionKind;
    }

    public int getCompletionLocation() {
        return this.completionLocation;
    }

    public int getTokenStart() {
        return this.tokenStart;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    public void setTokenRange(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < startIndex) {
            throw new IllegalArgumentException();
        }
        this.tokenStart = startIndex;
        this.tokenEnd = endIndex;
    }

    public char[] getCompletion() {
        if (this.completionKind == 7) {
            this.findParameterNames(null);
            if (this.updateCompletion) {
                this.updateCompletion = false;
                if (this.parameterNames != null) {
                    int length = this.parameterNames.length;
                    StringBuffer completionBuffer = new StringBuffer(this.completion.length);
                    int start = 0;
                    int end = CharOperation.indexOf('%', this.completion);
                    completionBuffer.append(this.completion, start, end - start);
                    int i = 0;
                    while (i < length) {
                        completionBuffer.append(this.parameterNames[i]);
                        start = end + 1;
                        end = CharOperation.indexOf('%', this.completion, start);
                        if (end > -1) {
                            completionBuffer.append(this.completion, start, end - start);
                        } else {
                            completionBuffer.append(this.completion, start, this.completion.length - start);
                        }
                        ++i;
                    }
                    int nameLength = completionBuffer.length();
                    this.completion = new char[nameLength];
                    completionBuffer.getChars(0, nameLength, this.completion, 0);
                }
            }
        }
        return this.completion;
    }

    public void setCompletion(char[] completion) {
        this.completion = completion;
    }

    public int getReplaceStart() {
        return this.replaceStart;
    }

    public int getReplaceEnd() {
        return this.replaceEnd;
    }

    public void setReplaceRange(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < startIndex) {
            throw new IllegalArgumentException();
        }
        this.replaceStart = startIndex;
        this.replaceEnd = endIndex;
    }

    public int getRelevance() {
        return this.relevance;
    }

    public void setRelevance(int rating) {
        if (rating <= 0) {
            throw new IllegalArgumentException();
        }
        this.relevance = rating;
    }

    public char[] getDeclarationSignature() {
        return this.declarationSignature;
    }

    public char[] getDeclarationKey() {
        return this.declarationKey;
    }

    public void setDeclarationSignature(char[] signature) {
        this.declarationSignature = signature;
    }

    public void setDeclarationKey(char[] key) {
        this.declarationKey = key;
    }

    public char[] getName() {
        return this.name;
    }

    public void setName(char[] name) {
        this.name = name;
    }

    public char[] getSignature() {
        return this.signature;
    }

    public char[] getKey() {
        return this.key;
    }

    public void setSignature(char[] signature) {
        this.signature = signature;
    }

    public void setKey(char[] key) {
        this.key = key;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public char[][] findParameterNames(IProgressMonitor monitor) {
        if (!this.parameterNamesComputed) {
            this.parameterNamesComputed = true;
            switch (this.completionKind) {
                case 1: {
                    try {
                        this.parameterNames = this.findMethodParameterNames(this.declarationPackageName, this.declarationTypeName, CharOperation.lastSegment(this.declarationTypeName, '.'), Signature.getParameterTypes(this.originalSignature == null ? this.signature : this.originalSignature));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (this.parameterTypeNames != null) {
                            this.parameterNames = this.createDefaultParameterNames(this.parameterTypeNames.length);
                            break;
                        }
                        this.parameterNames = null;
                    }
                    break;
                }
                case 6: {
                    try {
                        this.parameterNames = this.findMethodParameterNames(this.declarationPackageName, this.declarationTypeName, this.name, Signature.getParameterTypes(this.originalSignature == null ? this.signature : this.originalSignature));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (this.parameterTypeNames != null) {
                            this.parameterNames = this.createDefaultParameterNames(this.parameterTypeNames.length);
                            break;
                        }
                        this.parameterNames = null;
                    }
                    break;
                }
                case 7: {
                    try {
                        this.parameterNames = this.findMethodParameterNames(this.declarationPackageName, this.declarationTypeName, this.name, Signature.getParameterTypes(this.originalSignature == null ? this.signature : this.originalSignature));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.parameterNames = (char[][])(this.parameterTypeNames != null ? this.createDefaultParameterNames(this.parameterTypeNames.length) : null);
                    }
                    if (this.parameterNames == null) break;
                    this.updateCompletion = true;
                }
            }
        }
        return this.parameterNames;
    }

    public void setParameterNames(char[][] parameterNames) {
        this.parameterNames = parameterNames;
        this.parameterNamesComputed = true;
    }

    public int getAccessibility() {
        return this.accessibility;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }
}

