/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.lib.StoredConfig;
import com.netflix.nebula.lint.jgit.transport.RemoteConfig;
import com.netflix.nebula.lint.jgit.transport.URIish;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;

public class RemoteSetUrlCommand
extends GitCommand<RemoteConfig> {
    private String name;
    private URIish uri;
    private boolean push;

    protected RemoteSetUrlCommand(Repository repo) {
        super(repo);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUri(URIish uri) {
        this.uri = uri;
    }

    public void setPush(boolean push) {
        this.push = push;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config, this.name);
            if (this.push) {
                List<URIish> uris = remote.getPushURIs();
                if (uris.size() > 1) {
                    throw new JGitInternalException("remote.newtest.pushurl has multiple values");
                }
                if (uris.size() == 1) {
                    remote.removePushURI(uris.get(0));
                }
                remote.addPushURI(this.uri);
            } else {
                List<URIish> uris = remote.getURIs();
                if (uris.size() > 1) {
                    throw new JGitInternalException("remote.newtest.url has multiple values");
                }
                if (uris.size() == 1) {
                    remote.removeURI(uris.get(0));
                }
                remote.addURI(this.uri);
            }
            remote.update(config);
            config.save();
            return remote;
        }
        catch (IOException | URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

