/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.org.codenarc.rule;

import com.netflix.nebula.lint.org.codenarc.rule.AstVisitor;
import com.netflix.nebula.lint.org.codenarc.rule.Rule;
import com.netflix.nebula.lint.org.codenarc.rule.Violation;
import com.netflix.nebula.lint.org.codenarc.source.SourceCode;
import com.netflix.nebula.lint.org.codenarc.util.AstUtil;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.control.SourceUnit;

public class AbstractMethodVisitor
extends ClassCodeVisitorSupport
implements AstVisitor {
    private Rule rule;
    private SourceCode sourceCode;
    private final List<Violation> violations = new ArrayList<Violation>();
    private ClassNode currentClassNode = null;

    public void visitClass(ClassNode node) {
        this.currentClassNode = node;
        for (MethodNode method : node.getMethods()) {
            this.visitMethod(method);
        }
        this.currentClassNode = null;
    }

    protected final ClassNode getCurrentClassNode() {
        return this.currentClassNode;
    }

    protected final String getCurrentClassName() {
        if (this.currentClassNode == null) {
            return "<unknown>";
        }
        return this.currentClassNode.getName();
    }

    protected void addViolation(ASTNode node, String message) {
        if (node.getLineNumber() >= 0) {
            int lineNumber = AstUtil.findFirstNonAnnotationLine(node, this.sourceCode);
            String sourceLine = this.sourceCode.line(AstUtil.findFirstNonAnnotationLine(node, this.sourceCode) - 1);
            Violation violation = new Violation();
            violation.setRule(this.rule);
            violation.setLineNumber(lineNumber);
            violation.setSourceLine(sourceLine);
            violation.setMessage(message);
            this.violations.add(violation);
        }
    }

    protected void addViolation(MethodNode node, String message) {
        this.addViolation((ASTNode)node, String.format("Violation in class %s. %s", node.getDeclaringClass().getNameWithoutPackage(), message));
    }

    protected void addViolation(ClassNode node, String message) {
        this.addViolation((ASTNode)node, String.format("Violation in class %s. %s", node.getNameWithoutPackage(), message));
    }

    protected SourceCode getSourceCode() {
        return this.sourceCode;
    }

    @Override
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public Rule getRule() {
        return this.rule;
    }

    @Override
    public void setSourceCode(SourceCode sourceCode) {
        this.sourceCode = sourceCode;
    }

    @Override
    public List<Violation> getViolations() {
        return this.violations;
    }

    public final void visitField(FieldNode node) {
        throw new UnsupportedOperationException();
    }

    protected final void visitObjectInitializerStatements(ClassNode node) {
        throw new UnsupportedOperationException();
    }

    protected final SourceUnit getSourceUnit() {
        throw new RuntimeException("should never be called");
    }

    public final void visitPackage(PackageNode node) {
        throw new UnsupportedOperationException();
    }

    public final void visitImports(ModuleNode node) {
        throw new UnsupportedOperationException();
    }

    public final void visitAnnotations(AnnotatedNode node) {
        throw new UnsupportedOperationException();
    }

    protected final void visitClassCodeContainer(Statement code) {
        throw new UnsupportedOperationException();
    }

    public final void visitVariableExpression(VariableExpression expression) {
        throw new UnsupportedOperationException();
    }

    protected final void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        throw new UnsupportedOperationException();
    }

    public final void visitConstructor(ConstructorNode node) {
        throw new UnsupportedOperationException();
    }

    public final void visitProperty(PropertyNode node) {
        throw new UnsupportedOperationException();
    }

    protected final void addError(String msg, ASTNode expr) {
        super.addError(msg, expr);
    }

    protected final void visitStatement(Statement statement) {
        throw new UnsupportedOperationException();
    }

    public final void visitAssertStatement(AssertStatement statement) {
        throw new UnsupportedOperationException();
    }

    public final void visitBlockStatement(BlockStatement block) {
        throw new UnsupportedOperationException();
    }

    public final void visitBreakStatement(BreakStatement statement) {
        throw new UnsupportedOperationException();
    }

    public final void visitCaseStatement(CaseStatement statement) {
        throw new UnsupportedOperationException();
    }

    public final void visitCatchStatement(CatchStatement statement) {
        throw new UnsupportedOperationException();
    }

    public final void visitContinueStatement(ContinueStatement statement) {
        throw new UnsupportedOperationException();
    }

    public final void visitDoWhileLoop(DoWhileStatement loop) {
        throw new UnsupportedOperationException();
    }

    public final void visitExpressionStatement(ExpressionStatement statement) {
        throw new UnsupportedOperationException();
    }

    public final void visitForLoop(ForStatement forLoop) {
        throw new UnsupportedOperationException();
    }

    public final void visitIfElse(IfStatement ifElse) {
        throw new UnsupportedOperationException();
    }

    public final void visitReturnStatement(ReturnStatement statement) {
        throw new UnsupportedOperationException();
    }

    public final void visitSwitch(SwitchStatement statement) {
        throw new UnsupportedOperationException();
    }

    public final void visitSynchronizedStatement(SynchronizedStatement statement) {
        throw new UnsupportedOperationException();
    }

    public final void visitThrowStatement(ThrowStatement statement) {
        throw new UnsupportedOperationException();
    }

    public final void visitTryCatchFinally(TryCatchStatement statement) {
        throw new UnsupportedOperationException();
    }

    public final void visitWhileLoop(WhileStatement loop) {
        throw new UnsupportedOperationException();
    }

    protected final void visitEmptyStatement(EmptyStatement statement) {
        throw new UnsupportedOperationException();
    }

    public final void visitMethodCallExpression(MethodCallExpression call) {
        throw new UnsupportedOperationException();
    }

    public final void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        throw new UnsupportedOperationException();
    }

    public final void visitConstructorCallExpression(ConstructorCallExpression call) {
        throw new UnsupportedOperationException();
    }

    public final void visitBinaryExpression(BinaryExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitTernaryExpression(TernaryExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitShortTernaryExpression(ElvisOperatorExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitPostfixExpression(PostfixExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitPrefixExpression(PrefixExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitBooleanExpression(BooleanExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitNotExpression(NotExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitClosureExpression(ClosureExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitTupleExpression(TupleExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitListExpression(ListExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitArrayExpression(ArrayExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitMapExpression(MapExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitMapEntryExpression(MapEntryExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitRangeExpression(RangeExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitSpreadExpression(SpreadExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitSpreadMapExpression(SpreadMapExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitMethodPointerExpression(MethodPointerExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitCastExpression(CastExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitConstantExpression(ConstantExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitClassExpression(ClassExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitDeclarationExpression(DeclarationExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitPropertyExpression(PropertyExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitAttributeExpression(AttributeExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitFieldExpression(FieldExpression expression) {
        throw new UnsupportedOperationException();
    }

    public final void visitGStringExpression(GStringExpression expression) {
        throw new UnsupportedOperationException();
    }

    protected final void visitListOfExpressions(List<? extends Expression> list) {
        throw new UnsupportedOperationException();
    }

    public final void visitArgumentlistExpression(ArgumentListExpression ale) {
        throw new UnsupportedOperationException();
    }

    public final void visitClosureListExpression(ClosureListExpression cle) {
        throw new UnsupportedOperationException();
    }

    public final void visitBytecodeExpression(BytecodeExpression cle) {
        throw new UnsupportedOperationException();
    }

    public void visitMethod(MethodNode node) {
        throw new UnsupportedOperationException();
    }
}

