/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.revwalk.filter;

import com.netflix.nebula.lint.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.errors.StopWalkException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.revwalk.filter.RevFilter;
import java.io.IOException;

public class MaxCountRevFilter
extends RevFilter {
    private int maxCount;
    private int count = 0;

    public static RevFilter create(int maxCount) {
        if (maxCount < 0) {
            throw new IllegalArgumentException(JGitText.get().maxCountMustBeNonNegative);
        }
        return new MaxCountRevFilter(maxCount);
    }

    private MaxCountRevFilter(int maxCount) {
        this.maxCount = maxCount;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        ++this.count;
        if (this.count > this.maxCount) {
            throw StopWalkException.INSTANCE;
        }
        return true;
    }

    @Override
    public RevFilter clone() {
        return new MaxCountRevFilter(this.maxCount);
    }
}

