/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics;

import nebula.plugin.metrics.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class MetricsLoggerFactory {
    public static final String LOGGING_PREFIX = "[metrics] ";

    public static Logger getLogger(String name) {
        Logger logger = LoggerFactory.getLogger((String)Preconditions.checkNotNull(name));
        return new MetricsLogger(logger);
    }

    public static Logger getLogger(Class clazz) {
        return MetricsLoggerFactory.getLogger(clazz.getName());
    }

    private static final class MetricsLogger
    implements Logger {
        private final Logger logger;

        private MetricsLogger(Logger logger) {
            this.logger = logger;
        }

        public String getName() {
            return this.logger.getName();
        }

        public boolean isInfoEnabled(Marker marker) {
            return this.logger.isInfoEnabled(marker);
        }

        private String addPrefix(String s) {
            return MetricsLoggerFactory.LOGGING_PREFIX + s;
        }

        public void info(String s, Object ... objects) {
            this.logger.info(this.addPrefix(s), objects);
        }

        public void info(Marker marker, String s, Throwable throwable) {
            this.logger.info(marker, this.addPrefix(s), throwable);
        }

        public void error(Marker marker, String s, Object ... objects) {
            this.logger.error(marker, this.addPrefix(s), objects);
        }

        public void error(String s, Throwable throwable) {
            this.logger.error(this.addPrefix(s), throwable);
        }

        public void error(Marker marker, String s, Object o, Object o1) {
            this.logger.error(marker, this.addPrefix(s), o, o1);
        }

        public boolean isDebugEnabled(Marker marker) {
            return this.logger.isDebugEnabled(marker);
        }

        public void warn(String s, Object o, Object o1) {
            this.logger.warn(this.addPrefix(s), o, o1);
        }

        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        public void debug(Marker marker, String s, Object ... objects) {
            this.logger.debug(marker, this.addPrefix(s), objects);
        }

        public void debug(String s, Object ... objects) {
            this.logger.debug(this.addPrefix(s), objects);
        }

        public void error(Marker marker, String s) {
            this.logger.error(marker, this.addPrefix(s));
        }

        public void info(String s, Object o, Object o1) {
            this.logger.info(this.addPrefix(s), o, o1);
        }

        public void trace(Marker marker, String s, Object o, Object o1) {
            this.logger.trace(marker, this.addPrefix(s), o, o1);
        }

        public void warn(String s, Throwable throwable) {
            this.logger.warn(this.addPrefix(s), throwable);
        }

        public void warn(Marker marker, String s, Throwable throwable) {
            this.logger.warn(marker, this.addPrefix(s), throwable);
        }

        public void warn(Marker marker, String s, Object o) {
            this.logger.warn(marker, this.addPrefix(s), o);
        }

        public void info(Marker marker, String s) {
            this.logger.info(marker, this.addPrefix(s));
        }

        public boolean isTraceEnabled(Marker marker) {
            return this.logger.isTraceEnabled(marker);
        }

        public void info(Marker marker, String s, Object o) {
            this.logger.info(marker, this.addPrefix(s), o);
        }

        public void trace(String s, Object o) {
            this.logger.trace(this.addPrefix(s), o);
        }

        public void info(String s, Throwable throwable) {
            this.logger.info(this.addPrefix(s), throwable);
        }

        public void info(String s, Object o) {
            this.logger.info(this.addPrefix(s), o);
        }

        public void error(String s, Object o, Object o1) {
            this.logger.error(this.addPrefix(s), o, o1);
        }

        public void debug(Marker marker, String s, Object o, Object o1) {
            this.logger.debug(marker, this.addPrefix(s), o, o1);
        }

        public void warn(String s, Object o) {
            this.logger.warn(this.addPrefix(s), o);
        }

        public void info(String s) {
            this.logger.info(this.addPrefix(s));
        }

        public void error(Marker marker, String s, Throwable throwable) {
            this.logger.error(marker, this.addPrefix(s), throwable);
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        public void debug(Marker marker, String s) {
            this.logger.debug(marker, this.addPrefix(s));
        }

        public void error(Marker marker, String s, Object o) {
            this.logger.error(marker, this.addPrefix(s), o);
        }

        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        public void trace(String s, Throwable throwable) {
            this.logger.trace(this.addPrefix(s), throwable);
        }

        public void debug(String s, Object o) {
            this.logger.debug(this.addPrefix(s), o);
        }

        public void error(String s, Object o) {
            this.logger.error(this.addPrefix(s), o);
        }

        public void debug(String s, Throwable throwable) {
            this.logger.debug(this.addPrefix(s), throwable);
        }

        public void trace(Marker marker, String s, Object o) {
            this.logger.trace(marker, this.addPrefix(s), o);
        }

        public void trace(Marker marker, String s) {
            this.logger.trace(marker, this.addPrefix(s));
        }

        public void info(Marker marker, String s, Object o, Object o1) {
            this.logger.info(marker, this.addPrefix(s), o, o1);
        }

        public void warn(Marker marker, String s, Object ... objects) {
            this.logger.warn(marker, this.addPrefix(s), objects);
        }

        public void debug(String s, Object o, Object o1) {
            this.logger.debug(this.addPrefix(s), o, o1);
        }

        public void trace(String s, Object ... objects) {
            this.logger.trace(this.addPrefix(s), objects);
        }

        public boolean isWarnEnabled(Marker marker) {
            return this.logger.isWarnEnabled(marker);
        }

        public void warn(Marker marker, String s) {
            this.logger.warn(marker, this.addPrefix(s));
        }

        public void error(String s) {
            this.logger.error(this.addPrefix(s));
        }

        public void debug(String s) {
            this.logger.debug(this.addPrefix(s));
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void info(Marker marker, String s, Object ... objects) {
            this.logger.info(marker, this.addPrefix(s), objects);
        }

        public void error(String s, Object ... objects) {
            this.logger.error(this.addPrefix(s), objects);
        }

        public void debug(Marker marker, String s, Throwable throwable) {
            this.logger.debug(marker, this.addPrefix(s), throwable);
        }

        public void warn(Marker marker, String s, Object o, Object o1) {
            this.logger.warn(marker, this.addPrefix(s), o, o1);
        }

        public boolean isErrorEnabled(Marker marker) {
            return this.logger.isErrorEnabled(marker);
        }

        public void trace(Marker marker, String s, Throwable throwable) {
            this.logger.trace(marker, this.addPrefix(s), throwable);
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        public void trace(String s, Object o, Object o1) {
            this.logger.trace(this.addPrefix(s), o, o1);
        }

        public void trace(Marker marker, String s, Object ... objects) {
            this.logger.trace(marker, this.addPrefix(s), objects);
        }

        public void warn(String s) {
            this.logger.warn(this.addPrefix(s));
        }

        public void trace(String s) {
            this.logger.trace(this.addPrefix(s));
        }

        public void debug(Marker marker, String s, Object o) {
            this.logger.debug(marker, this.addPrefix(s), o);
        }

        public void warn(String s, Object ... objects) {
            this.logger.warn(this.addPrefix(s), objects);
        }
    }
}

