/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics;

import java.util.Set;
import nebula.plugin.metrics.MetricsLoggerFactory;
import nebula.plugin.metrics.MetricsPluginExtension;
import nebula.plugin.metrics.collector.GradleCollector;
import nebula.plugin.metrics.collector.GradleTestSuiteCollector;
import nebula.plugin.metrics.com.google.common.annotations.VisibleForTesting;
import nebula.plugin.metrics.com.google.common.base.Preconditions;
import nebula.plugin.metrics.com.google.common.base.Supplier;
import nebula.plugin.metrics.dispatcher.ClientESMetricsDispatcher;
import nebula.plugin.metrics.dispatcher.HttpESMetricsDispatcher;
import nebula.plugin.metrics.dispatcher.MetricsDispatcher;
import nebula.plugin.metrics.dispatcher.UninitializedMetricsDispatcher;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestListener;
import org.slf4j.Logger;

public final class MetricsPlugin
implements Plugin<Project> {
    private final Logger logger = MetricsLoggerFactory.getLogger(MetricsPlugin.class);
    private MetricsDispatcher dispatcher = new UninitializedMetricsDispatcher();
    private Supplier<MetricsDispatcher> dispatcherSupplier = new Supplier<MetricsDispatcher>(){

        @Override
        public MetricsDispatcher get() {
            return MetricsPlugin.this.dispatcher;
        }
    };

    public void apply(Project project) {
        Preconditions.checkNotNull(project);
        Preconditions.checkState(project == project.getRootProject(), "The metrics plugin may only be applied to the root project");
        ExtensionContainer extensions = project.getExtensions();
        extensions.add("metrics", (Object)new MetricsPluginExtension());
        Gradle gradle = project.getGradle();
        StartParameter startParameter = gradle.getStartParameter();
        if (startParameter.isOffline()) {
            this.logger.warn("Build is running offline. Metrics will not be collected");
        } else {
            final MetricsPluginExtension extension = (MetricsPluginExtension)extensions.getByType(MetricsPluginExtension.class);
            this.configureRootProjectCollectors(project, extension);
            project.afterEvaluate((Action)new Action<Project>(){

                public void execute(Project project) {
                    if (MetricsPlugin.this.dispatcher instanceof UninitializedMetricsDispatcher) {
                        switch (extension.getDispatcherType()) {
                            case ES_CLIENT: {
                                MetricsPlugin.this.dispatcher = new ClientESMetricsDispatcher(extension);
                                break;
                            }
                            case ES_HTTP: {
                                MetricsPlugin.this.dispatcher = new HttpESMetricsDispatcher(extension);
                            }
                        }
                    }
                    MetricsPlugin.this.configureProjectCollectors(project.getAllprojects());
                }
            });
        }
    }

    @VisibleForTesting
    void setDispatcher(MetricsDispatcher dispatcher) {
        this.dispatcher = Preconditions.checkNotNull(dispatcher);
    }

    private void configureRootProjectCollectors(Project rootProject, MetricsPluginExtension extension) {
        Gradle gradle = rootProject.getGradle();
        gradle.addListener((Object)new GradleCollector(this.dispatcherSupplier, extension));
    }

    private void configureProjectCollectors(Set<Project> projects) {
        for (Project project : projects) {
            TaskContainer tasks = project.getTasks();
            for (String name : tasks.getNames()) {
                Task task = tasks.getByName(name);
                if (!(task instanceof Test)) continue;
                GradleTestSuiteCollector suiteCollector = new GradleTestSuiteCollector(this.dispatcherSupplier, (Task)((Test)task));
                ((Test)task).addTestListener((TestListener)suiteCollector);
            }
        }
    }
}

