/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics;

import java.util.ArrayList;
import java.util.List;
import nebula.plugin.metrics.com.google.common.base.Preconditions;
import org.gradle.api.logging.LogLevel;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class MetricsPluginExtension {
    public static final String METRICS_EXTENSION_NAME = "metrics";
    private static final String INDEX_PREFIX = "build-metrics-";
    private static final String LOGSTASH_INDEX_PREFIX = "logstash-";
    public static final DateTimeFormatter ROLLING_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMM");
    public static final String DEFAULT_INDEX_NAME = "build-metrics-default";
    private static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.WARN;
    private String hostname = "localhost";
    private int transportPort = 9300;
    private int httpPort = 9200;
    private String clusterName = "elasticsearch";
    private String indexName = "build-metrics-default";
    private LogLevel logLevel = DEFAULT_LOG_LEVEL;
    private DispatcherType dispatcherType = DispatcherType.ES_HTTP;
    private List<String> sanitizedProperties = new ArrayList<String>();

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = Preconditions.checkNotNull(hostname);
    }

    public int getTransportPort() {
        return this.transportPort;
    }

    public void setTransportPort(int transportPort) {
        this.transportPort = transportPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = Preconditions.checkNotNull(clusterName);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getLogstashIndexName() {
        String rollingSuffix = "-" + ROLLING_FORMATTER.print((ReadableInstant)DateTime.now());
        return LOGSTASH_INDEX_PREFIX + this.indexName + rollingSuffix;
    }

    public void setIndexName(String indexName) {
        this.indexName = INDEX_PREFIX + Preconditions.checkNotNull(indexName);
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = LogLevel.valueOf((String)logLevel.toUpperCase());
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public void setDispatcherType(String dispatcherType) {
        this.dispatcherType = DispatcherType.valueOf(dispatcherType.toUpperCase());
    }

    public List<String> getSanitizedProperties() {
        return this.sanitizedProperties;
    }

    public void setSanitizedProperties(List<String> sanitizedProperties) {
        this.sanitizedProperties = Preconditions.checkNotNull(sanitizedProperties);
    }

    public static enum DispatcherType {
        ES_CLIENT,
        ES_HTTP;

    }
}

