/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.collector;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import nebula.plugin.metrics.MetricsLoggerFactory;
import nebula.plugin.metrics.MetricsPluginExtension;
import nebula.plugin.metrics.collector.GradleInfoCollector;
import nebula.plugin.metrics.collector.LoggingCollector;
import nebula.plugin.metrics.com.google.common.annotations.VisibleForTesting;
import nebula.plugin.metrics.com.google.common.base.Optional;
import nebula.plugin.metrics.com.google.common.base.Preconditions;
import nebula.plugin.metrics.com.google.common.base.Supplier;
import nebula.plugin.metrics.dispatcher.MetricsDispatcher;
import nebula.plugin.metrics.model.GradleToolContainer;
import nebula.plugin.metrics.model.Info;
import nebula.plugin.metrics.model.Result;
import nebula.plugin.metrics.model.Task;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.gradle.profile.BuildProfile;
import org.gradle.profile.CompositeOperation;
import org.gradle.profile.ContinuousOperation;
import org.gradle.profile.ProfileListener;
import org.gradle.profile.ProjectProfile;
import org.gradle.profile.TaskExecution;
import org.joda.time.DateTime;
import org.slf4j.Logger;

public final class GradleCollector
implements ProfileListener,
BuildListener {
    private static final long TIMEOUT_MS = 5000L;
    private final Logger logger = MetricsLoggerFactory.getLogger(GradleCollector.class);
    private final Supplier<MetricsDispatcher> dispatcherSupplier;
    private final AtomicBoolean complete = new AtomicBoolean();

    public GradleCollector(Supplier<MetricsDispatcher> dispatcherSupplier, MetricsPluginExtension extension) {
        this.dispatcherSupplier = Preconditions.checkNotNull(dispatcherSupplier);
        LoggingCollector.configureCollection(dispatcherSupplier, Preconditions.checkNotNull(extension));
    }

    public void projectsEvaluated(Gradle gradle) {
        Preconditions.checkNotNull(gradle);
        StartParameter startParameter = gradle.getStartParameter();
        Preconditions.checkState(!startParameter.isOffline(), "Collectors should not be registered when Gradle is running offline");
        try {
            this.dispatcherSupplier.get().startAsync().awaitRunning(5000L, TimeUnit.MILLISECONDS);
        }
        catch (IllegalStateException | TimeoutException e) {
            this.logger.error("Error while starting metrics dispatcher. Metrics collection disabled.", (Throwable)e);
            return;
        }
        try {
            Project gradleProject = gradle.getRootProject();
            String name = gradleProject.getName();
            String version = String.valueOf(gradleProject.getVersion());
            nebula.plugin.metrics.model.Project project = new nebula.plugin.metrics.model.Project(name, version);
            MetricsDispatcher dispatcher = this.dispatcherSupplier.get();
            dispatcher.started(project);
            GradleToolContainer tool = GradleToolContainer.fromGradle(gradle);
            Plugin plugin = gradleProject.getPlugins().findPlugin("info-broker");
            if (plugin == null) {
                this.logger.info("Gradle info plugin not found. SCM and CI information will not be collected");
                dispatcher.environment(Info.create(tool));
            } else {
                GradleInfoCollector collector = new GradleInfoCollector(plugin);
                dispatcher.environment(Info.create(tool, collector.getSCM(), collector.getCI()));
            }
        }
        catch (Exception e) {
            this.logger.error("Unexpected exception in evaluation listener", (Throwable)e);
        }
    }

    public void buildFinished(BuildResult buildResult) {
        Throwable failure = buildResult.getFailure();
        Result result = failure == null ? Result.success() : Result.failure(failure);
        this.logger.info("Build finished with result " + result);
        this.dispatcherSupplier.get().result(result);
        this.shutdownIfComplete();
    }

    public void buildFinished(BuildProfile result) {
        Preconditions.checkNotNull(result);
        long startupElapsed = result.getElapsedStartup();
        long settingsElapsed = result.getElapsedSettings();
        long loadingElapsed = result.getElapsedProjectsLoading();
        MetricsDispatcher dispatcher = this.dispatcherSupplier.get();
        dispatcher.event("startup", "init", startupElapsed);
        long expectedTotal = startupElapsed;
        dispatcher.event("settings", "configure", settingsElapsed);
        expectedTotal += settingsElapsed;
        dispatcher.event("projectsLoading", "configure", loadingElapsed);
        expectedTotal += loadingElapsed;
        for (ProjectProfile projectProfile : result.getProjects()) {
            ContinuousOperation configurationOperation = projectProfile.getConfigurationOperation();
            long configurationElapsed = configurationOperation.getElapsedTime();
            dispatcher.event(configurationOperation.getDescription(), "configure", configurationElapsed);
            expectedTotal += configurationElapsed;
        }
        for (ContinuousOperation operation : result.getDependencySets()) {
            long resolveElapsed = operation.getElapsedTime();
            dispatcher.event(operation.getDescription(), "resolve", resolveElapsed);
            expectedTotal += resolveElapsed;
        }
        for (ProjectProfile projectProfile : result.getProjects()) {
            long totalTaskElapsed = 0L;
            CompositeOperation tasks = projectProfile.getTasks();
            for (TaskExecution execution : tasks.getOperations()) {
                Result taskResult = this.getTaskExecutionResult(execution);
                long taskElapsed = execution.getElapsedTime();
                Task task = new Task(execution.getDescription(), taskResult, new DateTime(execution.getStartTime()), taskElapsed);
                dispatcher.task(task);
                totalTaskElapsed += taskElapsed;
            }
            dispatcher.event("task", "execution", totalTaskElapsed);
            expectedTotal += totalTaskElapsed;
        }
        long elapsedTotal = result.getElapsedTotal();
        dispatcher.duration(result.getBuildStarted(), elapsedTotal);
        if (elapsedTotal < expectedTotal) {
            long difference = expectedTotal - elapsedTotal;
            this.logger.info("Total build time of {}ms is less than the calculated total of {}ms (difference: {}ms). Creating 'unknown' event with type 'other'", new Object[]{expectedTotal, elapsedTotal, difference});
            dispatcher.event("unknown", "other", difference);
        }
        this.shutdownIfComplete();
    }

    private void shutdownIfComplete() {
        MetricsDispatcher dispatcher = this.dispatcherSupplier.get();
        if (!this.complete.compareAndSet(false, true)) {
            if (dispatcher.isRunning()) {
                this.logger.info("Shutting down dispatcher");
                try {
                    dispatcher.stopAsync().awaitTerminated(5000L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    this.logger.error("Timed out after {}ms while waiting for metrics dispatcher to terminate", (Object)5000L);
                }
                catch (IllegalStateException e) {
                    this.logger.error("Could not stop metrics dispatcher service", (Throwable)e);
                }
            }
            LoggingCollector.reset();
            Optional<String> receipt = dispatcher.receipt();
            if (receipt.isPresent()) {
                this.logger.warn(receipt.get());
            }
        }
    }

    @VisibleForTesting
    Result getTaskExecutionResult(TaskExecution taskExecution) {
        Result result = Result.success();
        TaskState state = taskExecution.getState();
        if (!state.getDidWork()) {
            result = Result.skipped();
        } else {
            Throwable failure = state.getFailure();
            if (failure != null) {
                result = Result.failure(failure);
            }
        }
        return result;
    }

    public void buildStarted(Gradle gradle) {
        Preconditions.checkNotNull(gradle);
    }

    public void settingsEvaluated(Settings settings) {
        Preconditions.checkNotNull(settings);
    }

    public void projectsLoaded(Gradle gradle) {
        Preconditions.checkNotNull(gradle);
    }
}

