/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.collector;

import java.util.List;
import nebula.plugin.metrics.MetricsLoggerFactory;
import nebula.plugin.metrics.com.google.common.annotations.VisibleForTesting;
import nebula.plugin.metrics.com.google.common.base.Preconditions;
import nebula.plugin.metrics.com.google.common.base.Supplier;
import nebula.plugin.metrics.dispatcher.MetricsDispatcher;
import nebula.plugin.metrics.model.Result;
import nebula.plugin.metrics.model.Test;
import org.gradle.api.Task;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestResult;
import org.joda.time.DateTime;
import org.slf4j.Logger;

public class GradleTestSuiteCollector
implements TestListener {
    private static final Logger logger = MetricsLoggerFactory.getLogger(GradleTestSuiteCollector.class);
    private final Supplier<MetricsDispatcher> dispatcherSupplier;
    private final Task task;

    public GradleTestSuiteCollector(Supplier<MetricsDispatcher> dispatcherSupplier, Task task) {
        this.dispatcherSupplier = Preconditions.checkNotNull(dispatcherSupplier);
        this.task = Preconditions.checkNotNull(task);
    }

    public void beforeSuite(TestDescriptor suite) {
        Preconditions.checkNotNull(suite);
    }

    public void afterSuite(TestDescriptor suite, TestResult result) {
        Preconditions.checkNotNull(suite);
        Preconditions.checkNotNull(result);
    }

    public void beforeTest(TestDescriptor testDescriptor) {
        Preconditions.checkNotNull(testDescriptor);
    }

    public void afterTest(TestDescriptor testDescriptor, TestResult testResult) {
        Preconditions.checkNotNull(testDescriptor);
        Preconditions.checkNotNull(testResult);
        Result result = this.getTestResult(testResult);
        org.gradle.api.tasks.testing.Test testTask = (org.gradle.api.tasks.testing.Test)this.task;
        String suiteName = testTask.getName();
        long startTime = testResult.getStartTime();
        long elapsed = testResult.getEndTime() - startTime;
        Test test = new Test(testDescriptor.getName(), testDescriptor.getClassName(), suiteName, result, new DateTime(startTime), elapsed);
        this.dispatcherSupplier.get().test(test);
    }

    @VisibleForTesting
    Result getTestResult(TestResult testResult) {
        Result result;
        TestResult.ResultType testResultType = testResult.getResultType();
        List exceptions = testResult.getExceptions();
        switch (testResultType) {
            case SUCCESS: {
                result = Result.success();
                break;
            }
            case SKIPPED: {
                result = Result.skipped();
                break;
            }
            case FAILURE: {
                result = Result.failure(exceptions);
                break;
            }
            default: {
                logger.warn("Test result carried unknown result type '{}'. Assuming success", (Object)testResultType);
                result = Result.success();
            }
        }
        return result;
    }
}

