/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.collector;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import nebula.plugin.metrics.MetricsPluginExtension;
import nebula.plugin.metrics.com.google.common.base.Preconditions;
import nebula.plugin.metrics.com.google.common.base.Supplier;
import nebula.plugin.metrics.com.google.common.collect.Lists;
import nebula.plugin.metrics.com.google.common.util.concurrent.Service;
import nebula.plugin.metrics.dispatcher.MetricsDispatcher;
import org.gradle.api.logging.LogLevel;
import org.gradle.logging.internal.LogEvent;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.slf4j.OutputEventListenerBackedLoggerContext;
import org.slf4j.LoggerFactory;

public class LoggingCollector {
    private static final ThreadLocal<Boolean> IN_LISTENER = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static void configureCollection(final Supplier<MetricsDispatcher> dispatcherSupplier, final MetricsPluginExtension extension) {
        Preconditions.checkNotNull(dispatcherSupplier);
        Preconditions.checkNotNull(extension);
        final LinkedBlockingQueue logEvents = new LinkedBlockingQueue();
        OutputEventListenerBackedLoggerContext context = (OutputEventListenerBackedLoggerContext)LoggerFactory.getILoggerFactory();
        context.setLevel(LogLevel.DEBUG);
        OutputEventListener originalListener = context.getOutputEventListener();
        WrappedOutputEventListener listener = new WrappedOutputEventListener(originalListener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOutput(OutputEvent outputEvent) {
                if (((Boolean)IN_LISTENER.get()).booleanValue()) {
                    return;
                }
                IN_LISTENER.set(true);
                try {
                    if (outputEvent instanceof LogEvent) {
                        LogEvent logEvent = (LogEvent)outputEvent;
                        if (LoggingCollector.levelGreaterOrEqual(outputEvent, extension.getLogLevel()) || logEvent.getMessage().startsWith("[metrics] ")) {
                            MetricsDispatcher dispatcher = (MetricsDispatcher)dispatcherSupplier.get();
                            if (dispatcher.state() == Service.State.NEW || dispatcher.state() == Service.State.STARTING) {
                                logEvents.add(logEvent);
                            } else {
                                if (!logEvents.isEmpty()) {
                                    ArrayList<LogEvent> drainedEvents = Lists.newArrayListWithCapacity(logEvents.size());
                                    logEvents.drainTo(drainedEvents);
                                    if (!drainedEvents.isEmpty()) {
                                        dispatcher.logEvents(drainedEvents);
                                    }
                                }
                                dispatcher.logEvent(logEvent);
                            }
                        }
                    }
                    super.onOutput(outputEvent);
                }
                finally {
                    IN_LISTENER.set(false);
                }
            }
        };
        context.setOutputEventListener((OutputEventListener)listener);
    }

    private static boolean levelGreaterOrEqual(OutputEvent outputEvent, LogLevel logLevel) {
        return outputEvent.getLogLevel().compareTo((Enum)logLevel) >= 0;
    }

    public static void reset() {
        OutputEventListenerBackedLoggerContext context = (OutputEventListenerBackedLoggerContext)LoggerFactory.getILoggerFactory();
        WrappedOutputEventListener listener = (WrappedOutputEventListener)context.getOutputEventListener();
        context.setOutputEventListener(listener.unwrap());
    }

    private static class WrappedOutputEventListener
    implements OutputEventListener {
        private final OutputEventListener listener;

        public WrappedOutputEventListener(OutputEventListener listener) {
            this.listener = Preconditions.checkNotNull(listener);
        }

        public void onOutput(OutputEvent outputEvent) {
            this.listener.onOutput(outputEvent);
        }

        public OutputEventListener unwrap() {
            return this.listener;
        }
    }
}

