/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.com.google.common.collect;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import nebula.plugin.metrics.com.google.common.annotations.GwtCompatible;
import nebula.plugin.metrics.com.google.common.collect.ImmutableMap;
import nebula.plugin.metrics.com.google.common.collect.Ordering;

@GwtCompatible(serializable=true)
final class ExplicitOrdering<T>
extends Ordering<T>
implements Serializable {
    final ImmutableMap<T, Integer> rankMap;
    private static final long serialVersionUID = 0L;

    ExplicitOrdering(List<T> valuesInOrder) {
        this(ExplicitOrdering.buildRankMap(valuesInOrder));
    }

    ExplicitOrdering(ImmutableMap<T, Integer> rankMap) {
        this.rankMap = rankMap;
    }

    @Override
    public int compare(T left, T right) {
        return this.rank(left) - this.rank(right);
    }

    private int rank(T value) {
        Integer rank = this.rankMap.get(value);
        if (rank == null) {
            throw new Ordering.IncomparableValueException(value);
        }
        return rank;
    }

    private static <T> ImmutableMap<T, Integer> buildRankMap(List<T> valuesInOrder) {
        ImmutableMap.Builder<T, Integer> builder = ImmutableMap.builder();
        int rank = 0;
        for (T value : valuesInOrder) {
            builder.put(value, rank++);
        }
        return builder.build();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof ExplicitOrdering) {
            ExplicitOrdering that = (ExplicitOrdering)object;
            return this.rankMap.equals(that.rankMap);
        }
        return false;
    }

    public int hashCode() {
        return this.rankMap.hashCode();
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.rankMap.keySet()));
        return new StringBuilder(19 + string.length()).append("Ordering.explicit(").append(string).append(")").toString();
    }
}

