/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.dispatcher;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import nebula.plugin.metrics.MetricsLoggerFactory;
import nebula.plugin.metrics.MetricsPluginExtension;
import nebula.plugin.metrics.com.google.common.annotations.VisibleForTesting;
import nebula.plugin.metrics.com.google.common.base.Optional;
import nebula.plugin.metrics.com.google.common.base.Preconditions;
import nebula.plugin.metrics.com.google.common.base.Supplier;
import nebula.plugin.metrics.com.google.common.base.Suppliers;
import nebula.plugin.metrics.com.google.common.base.Throwables;
import nebula.plugin.metrics.com.google.common.collect.FluentIterable;
import nebula.plugin.metrics.com.google.common.collect.Lists;
import nebula.plugin.metrics.dispatcher.AbstractQueuedExecutionThreadService;
import nebula.plugin.metrics.dispatcher.MetricsDispatcher;
import nebula.plugin.metrics.model.Build;
import nebula.plugin.metrics.model.Event;
import nebula.plugin.metrics.model.Info;
import nebula.plugin.metrics.model.Project;
import nebula.plugin.metrics.model.Result;
import nebula.plugin.metrics.model.Task;
import nebula.plugin.metrics.model.Test;
import net.logstash.logback.composite.JsonProvider;
import net.logstash.logback.composite.JsonProviders;
import net.logstash.logback.composite.loggingevent.MdcJsonProvider;
import net.logstash.logback.layout.LogstashLayout;
import org.gradle.logging.internal.LogEvent;
import org.slf4j.Logger;

public abstract class AbstractESMetricsDispatcher
extends AbstractQueuedExecutionThreadService<Runnable>
implements MetricsDispatcher {
    protected static final String BUILD_TYPE = "build";
    protected static final String LOG_TYPE = "log";
    protected final Logger logger = MetricsLoggerFactory.getLogger(this.getClass());
    protected final MetricsPluginExtension extension;
    private final ObjectMapper mapper;
    private final boolean async;
    private final Build build;
    private final ch.qos.logback.classic.Logger logbackLogger = new LoggerContext().getLogger("ROOT");
    private final Supplier<LogstashLayout> logstashLayoutSupplier = Suppliers.memoize(new Supplier<LogstashLayout>(){

        @Override
        public LogstashLayout get() {
            Preconditions.checkState(AbstractESMetricsDispatcher.this.buildId.isPresent(), "buildId has not been set");
            LogstashLayout layout = new LogstashLayout();
            JsonProviders providers = layout.getProviders();
            MdcJsonProvider provider = FluentIterable.from(providers.getProviders()).filter(MdcJsonProvider.class).first().get();
            layout.getProviders().removeProvider((JsonProvider)provider);
            layout.setTimeZone("UTC");
            layout.setCustomFields(String.format("{\"@source\":\"%s\"}", AbstractESMetricsDispatcher.this.buildId.get()));
            layout.start();
            return layout;
        }
    });
    private Optional<String> buildId = Optional.absent();

    protected AbstractESMetricsDispatcher(MetricsPluginExtension extension) {
        this(extension, true);
    }

    protected AbstractESMetricsDispatcher(MetricsPluginExtension extension, boolean async) {
        super(true);
        this.extension = Preconditions.checkNotNull(extension);
        this.mapper = AbstractESMetricsDispatcher.getObjectMapper();
        this.async = async;
        this.build = new Build();
    }

    @VisibleForTesting
    static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.registerModule((Module)new JodaModule());
        AbstractESMetricsDispatcher.registerEnumModule(mapper);
        return mapper;
    }

    private static void registerEnumModule(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<Enum> modifyEnumDeserializer(DeserializationConfig config, final JavaType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                return new JsonDeserializer<Enum>(){

                    public Enum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                        Class rawClass = type.getRawClass();
                        return Enum.valueOf(rawClass, jp.getValueAsString().toUpperCase());
                    }
                };
            }
        });
        module.addSerializer(Enum.class, (JsonSerializer)new StdSerializer<Enum>(Enum.class){

            public void serialize(Enum value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeString(value.name().toLowerCase());
            }
        });
        mapper.registerModule((Module)module);
    }

    @Override
    protected final boolean isAsync() {
        return this.async;
    }

    @Override
    protected final void execute(Runnable runnable) throws Exception {
        runnable.run();
    }

    @Override
    protected final void startUp() throws Exception {
        this.build.setStartTime(System.currentTimeMillis());
        this.startUpClient();
        this.indexBuild();
    }

    protected abstract void startUpClient();

    @Override
    protected final void postShutDown() throws Exception {
        this.shutDownClient();
        this.logstashLayoutSupplier.get().stop();
    }

    protected abstract void shutDownClient();

    @Override
    protected void beforeShutDown() {
        this.indexBuild();
    }

    @Override
    public final Optional<String> receipt() {
        if (this.buildId.isPresent()) {
            URL url;
            String file = "/" + this.extension.getIndexName() + "/" + BUILD_TYPE + "/" + this.buildId.get();
            try {
                url = new URL("http", this.extension.getHostname(), this.extension.getHttpPort(), file);
            }
            catch (MalformedURLException e) {
                throw Throwables.propagate(e);
            }
            return Optional.of("You can find the metrics for this build at " + url);
        }
        return this.buildId;
    }

    private void indexBuild() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractESMetricsDispatcher.this.sanitizeProperties(AbstractESMetricsDispatcher.this.build);
                    String json = AbstractESMetricsDispatcher.this.mapper.writeValueAsString((Object)AbstractESMetricsDispatcher.this.build);
                    if (AbstractESMetricsDispatcher.this.buildId.isPresent()) {
                        AbstractESMetricsDispatcher.this.index(AbstractESMetricsDispatcher.this.extension.getIndexName(), AbstractESMetricsDispatcher.BUILD_TYPE, json, AbstractESMetricsDispatcher.this.buildId);
                    } else {
                        AbstractESMetricsDispatcher.this.buildId = Optional.of(AbstractESMetricsDispatcher.this.index(AbstractESMetricsDispatcher.this.extension.getIndexName(), AbstractESMetricsDispatcher.BUILD_TYPE, json));
                        AbstractESMetricsDispatcher.this.logger.info("Build id is {}", AbstractESMetricsDispatcher.this.buildId.get());
                    }
                }
                catch (JsonProcessingException e) {
                    AbstractESMetricsDispatcher.this.logger.error("Unable to write JSON string value: " + e.getMessage(), (Throwable)e);
                }
            }
        };
        this.queue(runnable);
    }

    private void sanitizeProperties(Build build) {
        Info info = build.getInfo();
        if (info != null) {
            build.setInfo(Info.sanitize(info, this.extension.getSanitizedProperties()));
        }
    }

    @Override
    public final void started(Project project) {
        this.build.setProject(project);
        this.indexBuild();
    }

    protected abstract void createIndex(String var1, String var2);

    protected final String index(String indexName, String type, String source) {
        return this.index(indexName, type, source, Optional.absent());
    }

    protected abstract String index(String var1, String var2, String var3, Optional<String> var4);

    protected abstract void bulkIndex(String var1, String var2, Collection<String> var3);

    protected abstract boolean exists(String var1);

    @Override
    public final void duration(long startTime, long elapsedTime) {
        this.build.setStartTime(startTime);
        this.build.setElapsedTime(elapsedTime);
    }

    @Override
    public final void environment(Info info) {
        this.build.setInfo(info);
    }

    @Override
    public final void result(Result result) {
        this.build.setResult(result);
    }

    @Override
    public final void event(String description, String type, long elapsedTime) {
        this.build.addEvent(new Event(description, type, elapsedTime));
    }

    @Override
    public final void task(Task task) {
        this.build.addTask(task);
    }

    @Override
    public final void logEvent(final LogEvent event) {
        Preconditions.checkNotNull(event);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String json = AbstractESMetricsDispatcher.this.layoutLogEvent(event);
                AbstractESMetricsDispatcher.this.index(AbstractESMetricsDispatcher.this.extension.getLogstashIndexName(), AbstractESMetricsDispatcher.LOG_TYPE, json);
            }
        };
        this.queue(runnable);
    }

    @Override
    public final void logEvents(final Collection<LogEvent> events) {
        Preconditions.checkNotNull(events);
        Preconditions.checkArgument(!events.isEmpty(), "Empty events list found: %s", events);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ArrayList<String> jsons = Lists.newArrayListWithCapacity(events.size());
                for (LogEvent event : events) {
                    jsons.add(AbstractESMetricsDispatcher.this.layoutLogEvent(event));
                }
                AbstractESMetricsDispatcher.this.bulkIndex(AbstractESMetricsDispatcher.this.extension.getLogstashIndexName(), AbstractESMetricsDispatcher.LOG_TYPE, jsons);
            }
        };
        this.queue(runnable);
    }

    private String layoutLogEvent(LogEvent event) {
        LogstashLayout logstashLayout = this.logstashLayoutSupplier.get();
        String message = String.format("[%s] %s", event.getCategory(), event.getMessage());
        LoggingEvent loggingEvent = new LoggingEvent(Logger.class.getCanonicalName(), this.logbackLogger, Level.valueOf(event.getLogLevel().name()), message, event.getThrowable(), null);
        return logstashLayout.doLayout((DeferredProcessingAware)loggingEvent);
    }

    @Override
    public final void test(Test test) {
        this.build.addTest(test);
    }
}

