/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.dispatcher;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import nebula.plugin.metrics.com.google.common.annotations.VisibleForTesting;
import nebula.plugin.metrics.com.google.common.base.Preconditions;
import nebula.plugin.metrics.com.google.common.base.Throwables;
import nebula.plugin.metrics.com.google.common.collect.Lists;
import nebula.plugin.metrics.com.google.common.collect.Sets;
import nebula.plugin.metrics.com.google.common.util.concurrent.AbstractExecutionThreadService;
import nebula.plugin.metrics.com.google.common.util.concurrent.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueuedExecutionThreadService<E>
extends AbstractExecutionThreadService {
    private static final Set<Service.State> QUEUE_AVAILABLE_STATES = Sets.newHashSet(Service.State.STARTING, Service.State.RUNNING, Service.State.STOPPING);
    private final Logger logger = LoggerFactory.getLogger(AbstractExecutionThreadService.class);
    private final BlockingQueue<E> queue;
    private final boolean failOnError;
    private final AtomicBoolean failed = new AtomicBoolean();

    public AbstractQueuedExecutionThreadService(boolean failOnError) {
        this(new LinkedBlockingQueue(), failOnError);
    }

    @VisibleForTesting
    AbstractQueuedExecutionThreadService(BlockingQueue<E> queue, boolean failOnError) {
        this.queue = Preconditions.checkNotNull(queue);
        this.failOnError = failOnError;
    }

    protected abstract void execute(E var1) throws Exception;

    @Override
    protected final void run() throws Exception {
        while (this.isRunning() || !this.queue.isEmpty()) {
            E action = this.queue.poll(100L, TimeUnit.MILLISECONDS);
            this.doExecute(action);
        }
        this.logger.debug("Service is not running and queue is empty, returning from run()");
    }

    private void doExecute(@Nullable E action) {
        block3: {
            try {
                if (action != null) {
                    this.logger.debug("Executing {}", action);
                    this.execute(action);
                }
            }
            catch (Exception e) {
                this.logger.error("Error executing action {}: {}", new Object[]{action, e.getMessage(), e});
                if (!this.failOnError) break block3;
                this.logger.info("Shutting down {} due to previous failure", (Object)this);
                this.queue.clear();
                this.failed.set(true);
                throw Throwables.propagate(e);
            }
        }
    }

    protected final boolean hasFailed() {
        return this.failed.get();
    }

    @Override
    protected final void shutDown() throws Exception {
        try {
            this.beforeShutDown();
            this.logger.debug("Shutting down queued execution service {}. Draining queue...", (Object)this);
            ArrayList remaining = Lists.newArrayListWithCapacity(this.queue.size());
            this.queue.drainTo(remaining);
            for (Object e : remaining) {
                this.execute(e);
            }
            Preconditions.checkState(this.queue.isEmpty(), "The queue should have been drained before shutdown");
        }
        catch (Exception e) {
            this.logger.error("An error occurred during shutdown", (Throwable)e);
        }
        this.postShutDown();
    }

    protected void beforeShutDown() throws Exception {
    }

    protected void postShutDown() throws Exception {
    }

    protected final void queue(E action) {
        Preconditions.checkNotNull(action);
        if (!QUEUE_AVAILABLE_STATES.contains((Object)this.state())) {
            this.logger.debug("Dispatcher is not running, dropping action {}", action);
        } else if (this.isAsync()) {
            this.logger.debug("Queueing {}", action);
            this.queue.add(action);
        } else {
            this.doExecute(action);
        }
    }

    protected boolean isAsync() {
        return true;
    }
}

