/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.dispatcher;

import java.util.Collection;
import javax.annotation.Nullable;
import nebula.plugin.metrics.MetricsPluginExtension;
import nebula.plugin.metrics.com.google.common.base.Optional;
import nebula.plugin.metrics.dispatcher.AbstractESMetricsDispatcher;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public final class ClientESMetricsDispatcher
extends AbstractESMetricsDispatcher {
    private Client client;

    public ClientESMetricsDispatcher(MetricsPluginExtension extension) {
        this(extension, null, true);
    }

    ClientESMetricsDispatcher(MetricsPluginExtension extension, @Nullable Client client, boolean async) {
        super(extension, async);
        this.client = client;
    }

    @Override
    protected void startUpClient() {
        if (this.client == null) {
            this.client = this.createTransportClient(this.extension);
        }
    }

    @Override
    protected void shutDownClient() {
        this.client.close();
    }

    private Client createTransportClient(MetricsPluginExtension extension) {
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder();
        builder.classLoader(Settings.class.getClassLoader());
        builder.put("cluster.name", extension.getClusterName());
        InetSocketTransportAddress address = new InetSocketTransportAddress(extension.getHostname(), extension.getTransportPort());
        return new TransportClient(builder.build()).addTransportAddress((TransportAddress)address);
    }

    @Override
    protected void createIndex(String index, String source) {
        CreateIndexRequestBuilder indexCreate = this.client.admin().indices().prepareCreate(index).setSource(source);
        indexCreate.execute().actionGet();
    }

    @Override
    protected String index(String indexName, String type, String source, Optional<String> id) {
        IndexRequestBuilder index = this.client.prepareIndex(this.extension.getIndexName(), "build").setSource(source);
        if (id.isPresent()) {
            index.setId(id.get());
        }
        IndexResponse indexResponse = (IndexResponse)index.execute().actionGet();
        if (!id.isPresent()) assert (indexResponse.isCreated()) : "Should have been created";
        return indexResponse.getId();
    }

    @Override
    protected void bulkIndex(String indexName, String type, Collection<String> sources) {
        BulkRequestBuilder bulk = this.client.prepareBulk();
        for (String source : sources) {
            IndexRequestBuilder index = this.client.prepareIndex(this.extension.getIndexName(), "log");
            index.setSource(source);
            bulk.add(index);
        }
        bulk.execute().actionGet();
    }

    @Override
    protected boolean exists(String indexName) {
        IndicesExistsRequestBuilder indicesExists = this.client.admin().indices().prepareExists(new String[]{this.extension.getIndexName()});
        IndicesExistsResponse indicesExistsResponse = (IndicesExistsResponse)indicesExists.execute().actionGet();
        return indicesExistsResponse.isExists();
    }
}

