/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.dispatcher;

import java.io.IOException;
import java.util.Collection;
import nebula.plugin.metrics.MetricsPluginExtension;
import nebula.plugin.metrics.com.google.common.base.Optional;
import nebula.plugin.metrics.com.google.common.base.Throwables;
import nebula.plugin.metrics.dispatcher.AbstractESMetricsDispatcher;
import nebula.plugin.metrics.io.searchbox.action.Action;
import nebula.plugin.metrics.io.searchbox.client.JestClient;
import nebula.plugin.metrics.io.searchbox.client.JestClientFactory;
import nebula.plugin.metrics.io.searchbox.client.JestResult;
import nebula.plugin.metrics.io.searchbox.client.config.HttpClientConfig;
import nebula.plugin.metrics.io.searchbox.core.Bulk;
import nebula.plugin.metrics.io.searchbox.core.DocumentResult;
import nebula.plugin.metrics.io.searchbox.core.Index;
import nebula.plugin.metrics.io.searchbox.indices.CreateIndex;
import nebula.plugin.metrics.io.searchbox.indices.IndicesExists;

public final class HttpESMetricsDispatcher
extends AbstractESMetricsDispatcher {
    private JestClient client;

    public HttpESMetricsDispatcher(MetricsPluginExtension extension) {
        super(extension);
    }

    @Override
    protected void startUpClient() {
        JestClientFactory factory = new JestClientFactory();
        factory.setHttpClientConfig(((HttpClientConfig.Builder)new HttpClientConfig.Builder("http://" + this.extension.getHostname() + ":" + this.extension.getHttpPort()).multiThreaded(false)).build());
        this.client = factory.getObject();
    }

    @Override
    protected void shutDownClient() {
        this.client.shutdownClient();
    }

    @Override
    protected void createIndex(String indexName, String source) {
        CreateIndex createIndex = new CreateIndex.Builder(indexName).settings(source).build();
        this.execute(createIndex);
    }

    @Override
    protected String index(String indexName, String type, String source, Optional<String> id) {
        Index index = this.buildIndex(indexName, type, source, id);
        DocumentResult result = this.execute(index);
        return result.getJsonObject().get("_id").getAsString();
    }

    private Index buildIndex(String indexName, String type, String source) {
        return this.buildIndex(indexName, type, source, Optional.absent());
    }

    private Index buildIndex(String indexName, String type, String source, Optional<String> id) {
        Index.Builder builder = (Index.Builder)((Index.Builder)new Index.Builder(source).index(indexName)).type(type);
        if (id.isPresent()) {
            builder.id(id.get());
        }
        return builder.build();
    }

    @Override
    protected void bulkIndex(String indexName, String type, Collection<String> sources) {
        Bulk.Builder builder = new Bulk.Builder();
        for (String source : sources) {
            builder.addAction(this.buildIndex(indexName, type, source));
        }
        Bulk bulk = builder.build();
        this.execute(bulk);
    }

    @Override
    protected boolean exists(String indexName) {
        IndicesExists indicesExists = new IndicesExists.Builder(indexName).build();
        JestResult result = this.execute(indicesExists);
        return result.getJsonObject().get("found").getAsBoolean();
    }

    private <T extends JestResult> T execute(Action<T> clientRequest) {
        try {
            T result = this.client.execute(clientRequest);
            if (!((JestResult)result).isSucceeded()) {
                throw new RuntimeException("Jest request failed with " + ((JestResult)result).getErrorMessage());
            }
            return result;
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }
}

