/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.io.searchbox.action;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import nebula.plugin.metrics.io.searchbox.action.AbstractAction;
import nebula.plugin.metrics.io.searchbox.action.Action;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractMultiIndexActionBuilder<T extends Action, K>
extends AbstractAction.Builder<T, K> {
    protected Set<String> indexNames = new LinkedHashSet<String>();

    public K addIndex(String indexName) {
        this.indexNames.add(indexName);
        return (K)this;
    }

    public K addIndex(Collection<? extends String> indexNames) {
        this.indexNames.addAll(indexNames);
        return (K)this;
    }

    public K ignoreUnavailable(boolean ignore) {
        this.setParameter("ignore_unavailable", String.valueOf(ignore));
        return (K)this;
    }

    public K allowNoIndices(boolean allow) {
        this.setParameter("allow_no_indices", String.valueOf(allow));
        return (K)this;
    }

    public String getJoinedIndices() {
        if (this.indexNames.size() > 0) {
            return StringUtils.join(this.indexNames, (String)",");
        }
        return "_all";
    }

    @Override
    public abstract T build();
}

