/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.io.searchbox.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import nebula.plugin.metrics.com.google.common.collect.ImmutableSet;
import nebula.plugin.metrics.com.google.common.collect.Iterators;
import nebula.plugin.metrics.io.searchbox.client.JestClient;
import nebula.plugin.metrics.io.searchbox.client.config.discovery.NodeChecker;
import nebula.plugin.metrics.io.searchbox.client.config.exception.NoServerConfiguredException;
import nebula.plugin.metrics.io.searchbox.client.config.idle.IdleConnectionReaper;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJestClient
implements JestClient {
    public static final String ELASTIC_SEARCH_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    protected Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
    private static final Logger log = LoggerFactory.getLogger(AbstractJestClient.class);
    private final AtomicReference<Pair<Integer, Iterator<String>>> serverPoolReference = new AtomicReference<Pair>(Pair.of((Object)0, (Object)ImmutableSet.of().iterator()));
    private NodeChecker nodeChecker;
    private IdleConnectionReaper idleConnectionReaper;
    private boolean requestCompressionEnabled;

    public void setNodeChecker(NodeChecker nodeChecker) {
        this.nodeChecker = nodeChecker;
    }

    public void setIdleConnectionReaper(IdleConnectionReaper idleConnectionReaper) {
        this.idleConnectionReaper = idleConnectionReaper;
    }

    @Override
    public void setServers(Set<String> servers) {
        this.serverPoolReference.set((Pair<Integer, Iterator<String>>)Pair.of((Object)servers.size(), Iterators.cycle(servers)));
        if (servers.isEmpty()) {
            log.warn("No servers are currently available to connect.");
        } else if (log.isDebugEnabled()) {
            log.debug("Server pool was updated to contain {} servers.", (Object)servers.size());
        }
    }

    @Override
    public void shutdownClient() {
        if (null != this.nodeChecker) {
            this.nodeChecker.stopAsync();
            this.nodeChecker.awaitTerminated();
        }
        if (null != this.idleConnectionReaper) {
            this.idleConnectionReaper.stopAsync();
            this.idleConnectionReaper.awaitTerminated();
        }
    }

    protected String getNextServer() {
        Iterator iterator;
        Iterator iterator2 = iterator = (Iterator)this.serverPoolReference.get().getValue();
        synchronized (iterator2) {
            if (iterator.hasNext()) {
                return (String)iterator.next();
            }
            throw new NoServerConfiguredException("No Server is assigned to client to connect");
        }
    }

    protected int getServerPoolSize() {
        return (Integer)this.serverPoolReference.get().getKey();
    }

    protected String getRequestURL(String elasticSearchServer, String uri) {
        StringBuilder sb = new StringBuilder(elasticSearchServer);
        if (uri.length() > 0 && uri.charAt(0) == '/') {
            sb.append(uri);
        } else {
            sb.append('/').append(uri);
        }
        return sb.toString();
    }

    public boolean isRequestCompressionEnabled() {
        return this.requestCompressionEnabled;
    }

    public void setRequestCompressionEnabled(boolean requestCompressionEnabled) {
        this.requestCompressionEnabled = requestCompressionEnabled;
    }
}

