/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.io.searchbox.client;

import com.google.gson.Gson;
import java.util.Map;
import nebula.plugin.metrics.io.searchbox.client.JestClient;
import nebula.plugin.metrics.io.searchbox.client.config.HttpClientConfig;
import nebula.plugin.metrics.io.searchbox.client.config.discovery.NodeChecker;
import nebula.plugin.metrics.io.searchbox.client.config.idle.HttpReapableConnectionManager;
import nebula.plugin.metrics.io.searchbox.client.config.idle.IdleConnectionReaper;
import nebula.plugin.metrics.io.searchbox.client.http.JestHttpClient;
import nebula.plugin.metrics.org.apache.http.client.config.RequestConfig;
import nebula.plugin.metrics.org.apache.http.config.Registry;
import nebula.plugin.metrics.org.apache.http.config.RegistryBuilder;
import nebula.plugin.metrics.org.apache.http.conn.HttpClientConnectionManager;
import nebula.plugin.metrics.org.apache.http.conn.routing.HttpRoute;
import nebula.plugin.metrics.org.apache.http.conn.routing.HttpRoutePlanner;
import nebula.plugin.metrics.org.apache.http.conn.socket.ConnectionSocketFactory;
import nebula.plugin.metrics.org.apache.http.impl.client.CloseableHttpClient;
import nebula.plugin.metrics.org.apache.http.impl.client.HttpClientBuilder;
import nebula.plugin.metrics.org.apache.http.impl.client.HttpClients;
import nebula.plugin.metrics.org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import nebula.plugin.metrics.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import nebula.plugin.metrics.org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import nebula.plugin.metrics.org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import nebula.plugin.metrics.org.apache.http.impl.nio.client.HttpAsyncClients;
import nebula.plugin.metrics.org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import nebula.plugin.metrics.org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import nebula.plugin.metrics.org.apache.http.impl.nio.reactor.IOReactorConfig;
import nebula.plugin.metrics.org.apache.http.nio.conn.NHttpClientConnectionManager;
import nebula.plugin.metrics.org.apache.http.nio.conn.SchemeIOSessionStrategy;
import nebula.plugin.metrics.org.apache.http.nio.reactor.ConnectingIOReactor;
import nebula.plugin.metrics.org.apache.http.nio.reactor.IOReactorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestClientFactory {
    static final Logger log = LoggerFactory.getLogger(JestClientFactory.class);
    private HttpClientConfig httpClientConfig;

    public JestClient getObject() {
        JestHttpClient client = new JestHttpClient();
        if (this.httpClientConfig == null) {
            log.debug("There is no configuration to create http client. Going to create simple client with default values");
            this.httpClientConfig = new HttpClientConfig.Builder("http://localhost:9200").build();
        }
        client.setRequestCompressionEnabled(this.httpClientConfig.isRequestCompressionEnabled());
        client.setServers(this.httpClientConfig.getServerList());
        HttpClientConnectionManager connectionManager = this.getConnectionManager();
        NHttpClientConnectionManager asyncConnectionManager = this.getAsyncConnectionManager();
        client.setHttpClient(this.createHttpClient(connectionManager));
        client.setAsyncClient(this.createAsyncHttpClient(asyncConnectionManager));
        Gson gson = this.httpClientConfig.getGson();
        if (gson == null) {
            log.info("Using default GSON instance");
        } else {
            log.info("Using custom GSON instance");
            client.setGson(gson);
        }
        if (this.httpClientConfig.isDiscoveryEnabled()) {
            log.info("Node Discovery enabled...");
            NodeChecker nodeChecker = new NodeChecker(client, this.httpClientConfig);
            client.setNodeChecker(nodeChecker);
            nodeChecker.startAsync();
            nodeChecker.awaitRunning();
        } else {
            log.info("Node Discovery disabled...");
        }
        if (this.httpClientConfig.getMaxConnectionIdleTime() > 0L) {
            log.info("Idle connection reaping enabled...");
            IdleConnectionReaper reaper = new IdleConnectionReaper(this.httpClientConfig, new HttpReapableConnectionManager(connectionManager, asyncConnectionManager));
            client.setIdleConnectionReaper(reaper);
            reaper.startAsync();
            reaper.awaitRunning();
        } else {
            log.info("Idle connection reaping disabled...");
        }
        return client;
    }

    public void setHttpClientConfig(HttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }

    private CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager) {
        return this.configureHttpClient(HttpClients.custom().setConnectionManager(connectionManager).setDefaultRequestConfig(this.getRequestConfig()).setProxyAuthenticationStrategy(this.httpClientConfig.getProxyAuthenticationStrategy()).setRoutePlanner(this.getRoutePlanner()).setDefaultCredentialsProvider(this.httpClientConfig.getCredentialsProvider())).build();
    }

    private CloseableHttpAsyncClient createAsyncHttpClient(NHttpClientConnectionManager connectionManager) {
        return this.configureHttpClient(HttpAsyncClients.custom().setConnectionManager(connectionManager).setDefaultRequestConfig(this.getRequestConfig()).setProxyAuthenticationStrategy(this.httpClientConfig.getProxyAuthenticationStrategy()).setRoutePlanner(this.getRoutePlanner()).setDefaultCredentialsProvider(this.httpClientConfig.getCredentialsProvider())).build();
    }

    protected HttpClientBuilder configureHttpClient(HttpClientBuilder builder) {
        return builder;
    }

    protected HttpAsyncClientBuilder configureHttpClient(HttpAsyncClientBuilder builder) {
        return builder;
    }

    protected HttpRoutePlanner getRoutePlanner() {
        return this.httpClientConfig.getHttpRoutePlanner();
    }

    protected RequestConfig getRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(this.httpClientConfig.getConnTimeout()).setSocketTimeout(this.httpClientConfig.getReadTimeout()).build();
    }

    protected NHttpClientConnectionManager getAsyncConnectionManager() {
        Integer defaultMaxPerRoute;
        PoolingNHttpClientConnectionManager retval;
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setConnectTimeout(this.httpClientConfig.getConnTimeout()).setSoTimeout(this.httpClientConfig.getReadTimeout()).build();
        Registry<SchemeIOSessionStrategy> sessionStrategyRegistry = RegistryBuilder.create().register("http", this.httpClientConfig.getHttpIOSessionStrategy()).register("https", this.httpClientConfig.getHttpsIOSessionStrategy()).build();
        try {
            retval = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)new DefaultConnectingIOReactor(ioReactorConfig), sessionStrategyRegistry);
        }
        catch (IOReactorException e) {
            throw new IllegalStateException(e);
        }
        Integer maxTotal = this.httpClientConfig.getMaxTotalConnection();
        if (maxTotal != null) {
            retval.setMaxTotal(maxTotal);
        }
        if ((defaultMaxPerRoute = this.httpClientConfig.getDefaultMaxTotalConnectionPerRoute()) != null) {
            retval.setDefaultMaxPerRoute(defaultMaxPerRoute);
        }
        Map<HttpRoute, Integer> maxPerRoute = this.httpClientConfig.getMaxTotalConnectionPerRoute();
        for (Map.Entry<HttpRoute, Integer> entry : maxPerRoute.entrySet()) {
            retval.setMaxPerRoute(entry.getKey(), (int)entry.getValue());
        }
        return retval;
    }

    protected HttpClientConnectionManager getConnectionManager() {
        HttpClientConnectionManager retval;
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", this.httpClientConfig.getPlainSocketFactory()).register("https", this.httpClientConfig.getSslSocketFactory()).build();
        if (this.httpClientConfig.isMultiThreaded()) {
            Integer defaultMaxPerRoute;
            log.info("Using multi thread/connection supporting pooling connection manager");
            PoolingHttpClientConnectionManager poolingConnMgr = new PoolingHttpClientConnectionManager(registry);
            Integer maxTotal = this.httpClientConfig.getMaxTotalConnection();
            if (maxTotal != null) {
                poolingConnMgr.setMaxTotal(maxTotal);
            }
            if ((defaultMaxPerRoute = this.httpClientConfig.getDefaultMaxTotalConnectionPerRoute()) != null) {
                poolingConnMgr.setDefaultMaxPerRoute(defaultMaxPerRoute);
            }
            Map<HttpRoute, Integer> maxPerRoute = this.httpClientConfig.getMaxTotalConnectionPerRoute();
            for (Map.Entry<HttpRoute, Integer> entry : maxPerRoute.entrySet()) {
                poolingConnMgr.setMaxPerRoute(entry.getKey(), (int)entry.getValue());
            }
            retval = poolingConnMgr;
        } else {
            log.info("Using single thread/connection supporting basic connection manager");
            retval = new BasicHttpClientConnectionManager(registry);
        }
        return retval;
    }
}

