/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.io.searchbox.client.config;

import java.net.ProxySelector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nebula.plugin.metrics.io.searchbox.client.config.ClientConfig;
import nebula.plugin.metrics.org.apache.http.HttpHost;
import nebula.plugin.metrics.org.apache.http.auth.AuthScope;
import nebula.plugin.metrics.org.apache.http.auth.UsernamePasswordCredentials;
import nebula.plugin.metrics.org.apache.http.client.AuthenticationStrategy;
import nebula.plugin.metrics.org.apache.http.client.CredentialsProvider;
import nebula.plugin.metrics.org.apache.http.conn.routing.HttpRoute;
import nebula.plugin.metrics.org.apache.http.conn.routing.HttpRoutePlanner;
import nebula.plugin.metrics.org.apache.http.conn.socket.ConnectionSocketFactory;
import nebula.plugin.metrics.org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import nebula.plugin.metrics.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import nebula.plugin.metrics.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import nebula.plugin.metrics.org.apache.http.impl.client.BasicCredentialsProvider;
import nebula.plugin.metrics.org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import nebula.plugin.metrics.org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import nebula.plugin.metrics.org.apache.http.nio.conn.NoopIOSessionStrategy;
import nebula.plugin.metrics.org.apache.http.nio.conn.SchemeIOSessionStrategy;
import nebula.plugin.metrics.org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;

public class HttpClientConfig
extends ClientConfig {
    private final Integer maxTotalConnection;
    private final Integer defaultMaxTotalConnectionPerRoute;
    private final Map<HttpRoute, Integer> maxTotalConnectionPerRoute;
    private final CredentialsProvider credentialsProvider;
    private final LayeredConnectionSocketFactory sslSocketFactory;
    private final ConnectionSocketFactory plainSocketFactory;
    private final HttpRoutePlanner httpRoutePlanner;
    private final AuthenticationStrategy proxyAuthenticationStrategy;
    private final SchemeIOSessionStrategy httpIOSessionStrategy;
    private final SchemeIOSessionStrategy httpsIOSessionStrategy;

    public HttpClientConfig(Builder builder) {
        super(builder);
        this.maxTotalConnection = builder.maxTotalConnection;
        this.defaultMaxTotalConnectionPerRoute = builder.defaultMaxTotalConnectionPerRoute;
        this.maxTotalConnectionPerRoute = builder.maxTotalConnectionPerRoute;
        this.credentialsProvider = builder.credentialsProvider;
        this.sslSocketFactory = builder.sslSocketFactory;
        this.plainSocketFactory = builder.plainSocketFactory;
        this.httpRoutePlanner = builder.httpRoutePlanner;
        this.proxyAuthenticationStrategy = builder.proxyAuthenticationStrategy;
        this.httpIOSessionStrategy = builder.httpIOSessionStrategy;
        this.httpsIOSessionStrategy = builder.httpsIOSessionStrategy;
    }

    public Map<HttpRoute, Integer> getMaxTotalConnectionPerRoute() {
        return this.maxTotalConnectionPerRoute;
    }

    public Integer getMaxTotalConnection() {
        return this.maxTotalConnection;
    }

    public Integer getDefaultMaxTotalConnectionPerRoute() {
        return this.defaultMaxTotalConnectionPerRoute;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public LayeredConnectionSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public ConnectionSocketFactory getPlainSocketFactory() {
        return this.plainSocketFactory;
    }

    public HttpRoutePlanner getHttpRoutePlanner() {
        return this.httpRoutePlanner;
    }

    public AuthenticationStrategy getProxyAuthenticationStrategy() {
        return this.proxyAuthenticationStrategy;
    }

    public SchemeIOSessionStrategy getHttpIOSessionStrategy() {
        return this.httpIOSessionStrategy;
    }

    public SchemeIOSessionStrategy getHttpsIOSessionStrategy() {
        return this.httpsIOSessionStrategy;
    }

    public static class Builder
    extends ClientConfig.AbstractBuilder<HttpClientConfig, Builder> {
        private Integer maxTotalConnection;
        private Integer defaultMaxTotalConnectionPerRoute;
        private Map<HttpRoute, Integer> maxTotalConnectionPerRoute = new HashMap<HttpRoute, Integer>();
        private CredentialsProvider credentialsProvider;
        private LayeredConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
        private ConnectionSocketFactory plainSocketFactory = PlainConnectionSocketFactory.getSocketFactory();
        private HttpRoutePlanner httpRoutePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        private AuthenticationStrategy proxyAuthenticationStrategy;
        private SchemeIOSessionStrategy httpIOSessionStrategy = NoopIOSessionStrategy.INSTANCE;
        private SchemeIOSessionStrategy httpsIOSessionStrategy = SSLIOSessionStrategy.getSystemDefaultStrategy();

        public Builder(HttpClientConfig httpClientConfig) {
            super(httpClientConfig);
            this.maxTotalConnection = httpClientConfig.maxTotalConnection;
            this.defaultMaxTotalConnectionPerRoute = httpClientConfig.defaultMaxTotalConnectionPerRoute;
            this.maxTotalConnectionPerRoute = httpClientConfig.maxTotalConnectionPerRoute;
        }

        public Builder(Collection<String> serverUris) {
            super(serverUris);
        }

        public Builder(String serverUri) {
            super(serverUri);
        }

        @Override
        public Builder maxTotalConnection(int maxTotalConnection) {
            this.maxTotalConnection = maxTotalConnection;
            return this;
        }

        @Override
        public Builder defaultMaxTotalConnectionPerRoute(int defaultMaxTotalConnectionPerRoute) {
            this.defaultMaxTotalConnectionPerRoute = defaultMaxTotalConnectionPerRoute;
            return this;
        }

        public Builder maxTotalConnectionPerRoute(Map<HttpRoute, Integer> maxTotalConnectionPerRoute) {
            this.maxTotalConnectionPerRoute.putAll(maxTotalConnectionPerRoute);
            return this;
        }

        public Builder maxTotalConnectionPerRoute(HttpRoute httpRoute, int maxTotalConnection) {
            this.maxTotalConnectionPerRoute.put(httpRoute, maxTotalConnection);
            return this;
        }

        public Builder credentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder defaultCredentials(String username, String password) {
            this.credentialsProvider = new BasicCredentialsProvider();
            this.credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(username, password));
            return this;
        }

        public Builder sslSocketFactory(LayeredConnectionSocketFactory socketFactory) {
            this.sslSocketFactory = socketFactory;
            return this;
        }

        public Builder plainSocketFactory(ConnectionSocketFactory socketFactory) {
            this.plainSocketFactory = socketFactory;
            return this;
        }

        public Builder httpIOSessionStrategy(SchemeIOSessionStrategy httpIOSessionStrategy) {
            this.httpIOSessionStrategy = httpIOSessionStrategy;
            return this;
        }

        public Builder httpsIOSessionStrategy(SchemeIOSessionStrategy httpsIOSessionStrategy) {
            this.httpsIOSessionStrategy = httpsIOSessionStrategy;
            return this;
        }

        public Builder proxy(HttpHost proxy) {
            return this.proxy(proxy, null);
        }

        public Builder proxy(HttpHost proxy, AuthenticationStrategy proxyAuthenticationStrategy) {
            this.httpRoutePlanner = new DefaultProxyRoutePlanner(proxy);
            this.proxyAuthenticationStrategy = proxyAuthenticationStrategy;
            return this;
        }

        @Override
        public HttpClientConfig build() {
            return new HttpClientConfig(this);
        }
    }
}

