/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.io.searchbox.client.http;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Map;
import nebula.plugin.metrics.io.searchbox.action.Action;
import nebula.plugin.metrics.io.searchbox.client.AbstractJestClient;
import nebula.plugin.metrics.io.searchbox.client.JestClient;
import nebula.plugin.metrics.io.searchbox.client.JestResult;
import nebula.plugin.metrics.io.searchbox.client.JestResultHandler;
import nebula.plugin.metrics.io.searchbox.client.http.apache.HttpDeleteWithEntity;
import nebula.plugin.metrics.io.searchbox.client.http.apache.HttpGetWithEntity;
import nebula.plugin.metrics.org.apache.http.HttpEntity;
import nebula.plugin.metrics.org.apache.http.HttpResponse;
import nebula.plugin.metrics.org.apache.http.StatusLine;
import nebula.plugin.metrics.org.apache.http.client.entity.EntityBuilder;
import nebula.plugin.metrics.org.apache.http.client.methods.CloseableHttpResponse;
import nebula.plugin.metrics.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import nebula.plugin.metrics.org.apache.http.client.methods.HttpHead;
import nebula.plugin.metrics.org.apache.http.client.methods.HttpPost;
import nebula.plugin.metrics.org.apache.http.client.methods.HttpPut;
import nebula.plugin.metrics.org.apache.http.client.methods.HttpRequestBase;
import nebula.plugin.metrics.org.apache.http.client.methods.HttpUriRequest;
import nebula.plugin.metrics.org.apache.http.concurrent.FutureCallback;
import nebula.plugin.metrics.org.apache.http.entity.ContentType;
import nebula.plugin.metrics.org.apache.http.impl.client.CloseableHttpClient;
import nebula.plugin.metrics.org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import nebula.plugin.metrics.org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestHttpClient
extends AbstractJestClient
implements JestClient {
    private static final Logger log = LoggerFactory.getLogger(JestHttpClient.class);
    private static final HttpEntity DEFAULT_OK_RESPONSE = EntityBuilder.create().setText("{\"ok\" : true, \"found\" : true}").build();
    private static final HttpEntity DEFAULT_NOK_RESPONSE = EntityBuilder.create().setText("{\"ok\" : false, \"found\" : false}").build();
    protected ContentType requestContentType = ContentType.APPLICATION_JSON.withCharset("utf-8");
    private CloseableHttpClient httpClient;
    private CloseableHttpAsyncClient asyncClient;

    @Override
    public <T extends JestResult> T execute(Action<T> clientRequest) throws IOException {
        HttpUriRequest request = this.prepareRequest(clientRequest);
        CloseableHttpResponse response = this.httpClient.execute(request);
        if (request.getMethod().equalsIgnoreCase("HEAD") && response.getEntity() == null) {
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    response.setEntity(DEFAULT_OK_RESPONSE);
                    break;
                }
                case 404: {
                    response.setEntity(DEFAULT_NOK_RESPONSE);
                }
            }
        }
        return this.deserializeResponse(response, clientRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends JestResult> void executeAsync(Action<T> clientRequest, JestResultHandler<? super T> resultHandler) {
        JestHttpClient jestHttpClient = this;
        synchronized (jestHttpClient) {
            if (!this.asyncClient.isRunning()) {
                this.asyncClient.start();
            }
        }
        HttpUriRequest request = this.prepareRequest(clientRequest);
        this.asyncClient.execute(request, new DefaultCallback<T>(clientRequest, resultHandler));
    }

    @Override
    public void shutdownClient() {
        super.shutdownClient();
        try {
            this.asyncClient.close();
        }
        catch (IOException ex) {
            log.error("Exception occurred while shutting down the async client.", (Throwable)ex);
        }
        try {
            this.httpClient.close();
        }
        catch (IOException ex) {
            log.error("Exception occurred while shutting down the sync client.", (Throwable)ex);
        }
    }

    protected <T extends JestResult> HttpUriRequest prepareRequest(Action<T> clientRequest) {
        String elasticSearchRestUrl = this.getRequestURL(this.getNextServer(), clientRequest.getURI());
        HttpUriRequest request = this.constructHttpMethod(clientRequest.getRestMethodName(), elasticSearchRestUrl, clientRequest.getData(this.gson));
        log.debug("Request method={} url={}", (Object)clientRequest.getRestMethodName(), (Object)elasticSearchRestUrl);
        for (Map.Entry<String, Object> header : clientRequest.getHeaders().entrySet()) {
            request.addHeader(header.getKey(), header.getValue().toString());
        }
        return request;
    }

    protected HttpUriRequest constructHttpMethod(String methodName, String url, String payload) {
        HttpRequestBase httpUriRequest = null;
        if (methodName.equalsIgnoreCase("POST")) {
            httpUriRequest = new HttpPost(url);
            log.debug("POST method created based on client request");
        } else if (methodName.equalsIgnoreCase("PUT")) {
            httpUriRequest = new HttpPut(url);
            log.debug("PUT method created based on client request");
        } else if (methodName.equalsIgnoreCase("DELETE")) {
            httpUriRequest = new HttpDeleteWithEntity(url);
            log.debug("DELETE method created based on client request");
        } else if (methodName.equalsIgnoreCase("GET")) {
            httpUriRequest = new HttpGetWithEntity(url);
            log.debug("GET method created based on client request");
        } else if (methodName.equalsIgnoreCase("HEAD")) {
            httpUriRequest = new HttpHead(url);
            log.debug("HEAD method created based on client request");
        }
        if (httpUriRequest != null && httpUriRequest instanceof HttpEntityEnclosingRequestBase && payload != null) {
            EntityBuilder entityBuilder = EntityBuilder.create().setText(payload).setContentType(this.requestContentType);
            if (this.isRequestCompressionEnabled()) {
                entityBuilder.gzipCompress();
            }
            ((HttpEntityEnclosingRequestBase)httpUriRequest).setEntity(entityBuilder.build());
        }
        return httpUriRequest;
    }

    private <T extends JestResult> T deserializeResponse(HttpResponse response, Action<T> clientRequest) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        return clientRequest.createNewElasticSearchResult(response.getEntity() == null ? null : EntityUtils.toString(response.getEntity()), statusLine.getStatusCode(), statusLine.getReasonPhrase(), this.gson);
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CloseableHttpAsyncClient getAsyncClient() {
        return this.asyncClient;
    }

    public void setAsyncClient(CloseableHttpAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    protected class DefaultCallback<T extends JestResult>
    implements FutureCallback<HttpResponse> {
        private final Action<T> clientRequest;
        private final JestResultHandler<? super T> resultHandler;

        public DefaultCallback(Action<T> clientRequest, JestResultHandler<? super T> resultHandler) {
            this.clientRequest = clientRequest;
            this.resultHandler = resultHandler;
        }

        @Override
        public void completed(HttpResponse response) {
            JestResult jestResult = null;
            try {
                jestResult = JestHttpClient.this.deserializeResponse(response, this.clientRequest);
            }
            catch (IOException e) {
                this.failed(e);
            }
            if (jestResult != null) {
                this.resultHandler.completed(jestResult);
            }
        }

        @Override
        public void failed(Exception ex) {
            log.error("Exception occurred during async execution.", (Throwable)ex);
            this.resultHandler.failed(ex);
        }

        @Override
        public void cancelled() {
            log.warn("Async execution was cancelled; this is not expected to occur under normal operation.");
        }
    }
}

