/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.io.searchbox.core;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nebula.plugin.metrics.com.google.common.reflect.TypeToken;
import nebula.plugin.metrics.io.searchbox.action.AbstractAction;
import nebula.plugin.metrics.io.searchbox.action.BulkableAction;
import nebula.plugin.metrics.io.searchbox.core.BulkResult;
import nebula.plugin.metrics.io.searchbox.params.Parameters;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bulk
extends AbstractAction<BulkResult> {
    static final Logger log = LoggerFactory.getLogger(Bulk.class);
    protected Collection<BulkableAction> bulkableActions;

    protected Bulk(Builder builder) {
        super(builder);
        this.indexName = builder.defaultIndex;
        this.typeName = builder.defaultType;
        this.bulkableActions = builder.actions;
        this.setURI(this.buildURI());
    }

    private Object getJson(Gson gson, Object source) {
        if (source instanceof String) {
            return source;
        }
        return gson.toJson(source);
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getData(Gson gson) {
        StringBuilder sb = new StringBuilder();
        for (BulkableAction action : this.bulkableActions) {
            LinkedHashMap opMap = new LinkedHashMap(1);
            LinkedHashMap<String, String> opDetails = new LinkedHashMap<String, String>(3);
            if (StringUtils.isNotBlank((CharSequence)action.getId())) {
                opDetails.put("_id", action.getId());
            }
            if (StringUtils.isNotBlank((CharSequence)action.getIndex())) {
                opDetails.put("_index", action.getIndex());
            }
            if (StringUtils.isNotBlank((CharSequence)action.getType())) {
                opDetails.put("_type", action.getType());
            }
            for (String parameter : Parameters.ACCEPTED_IN_BULK) {
                try {
                    Collection<Object> values = action.getParameter(parameter);
                    if (values == null) continue;
                    if (values.size() == 1) {
                        opDetails.put("_" + parameter, values.iterator().next().toString());
                        continue;
                    }
                    if (values.size() <= 1) continue;
                    throw new IllegalArgumentException("Expecting a single value for '" + parameter + "' parameter, you provided: " + values.size());
                }
                catch (NullPointerException e) {
                    log.debug("Could not retrieve '" + parameter + "' parameter from action.", (Throwable)e);
                }
            }
            opMap.put(action.getBulkMethodName(), opDetails);
            sb.append(gson.toJson(opMap, new TypeToken<Map<String, Map<String, String>>>(){}.getType()));
            sb.append("\n");
            String source = action.getData(gson);
            if (source == null) continue;
            sb.append(this.getJson(gson, source));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String getPathToResult() {
        return "ok";
    }

    @Override
    protected String buildURI() {
        return super.buildURI() + "/_bulk";
    }

    @Override
    public BulkResult createNewElasticSearchResult(String responseBody, int statusCode, String reasonPhrase, Gson gson) {
        return this.createNewElasticSearchResult(new BulkResult(gson), responseBody, statusCode, reasonPhrase, gson);
    }

    @Override
    protected BulkResult createNewElasticSearchResult(BulkResult result, String responseBody, int statusCode, String reasonPhrase, Gson gson) {
        JsonObject jsonMap = this.parseResponseBody(responseBody);
        result.setResponseCode(statusCode);
        result.setJsonString(responseBody);
        result.setJsonObject(jsonMap);
        result.setPathToResult(this.getPathToResult());
        if (this.isHttpSuccessful(statusCode)) {
            if (jsonMap.has("errors") && jsonMap.get("errors").getAsBoolean()) {
                result.setSucceeded(false);
                result.setErrorMessage("One or more of the items in the Bulk request failed, check BulkResult.getItems() for more information.");
                log.debug("Bulk operation failed due to one or more failed actions within the Bulk request");
            } else {
                result.setSucceeded(true);
                log.debug("Bulk operation was successfull");
            }
        } else {
            result.setSucceeded(false);
            if (result.getErrorMessage() == null) {
                result.setErrorMessage(statusCode + " " + (reasonPhrase == null ? "null" : reasonPhrase));
            }
            log.debug("Bulk operation failed with an HTTP error");
        }
        return result;
    }

    public static class Builder
    extends AbstractAction.Builder<Bulk, Builder> {
        private List<BulkableAction> actions = new LinkedList<BulkableAction>();
        private String defaultIndex;
        private String defaultType;

        public Builder defaultIndex(String defaultIndex) {
            this.defaultIndex = defaultIndex;
            return this;
        }

        public Builder defaultType(String defaultType) {
            this.defaultType = defaultType;
            return this;
        }

        public Builder addAction(BulkableAction action) {
            this.actions.add(action);
            return this;
        }

        public Builder addAction(Collection<? extends BulkableAction> actions) {
            this.actions.addAll(actions);
            return this;
        }

        @Override
        public Bulk build() {
            return new Bulk(this);
        }
    }
}

