/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.io.searchbox.core.search.aggregation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.AggregationField;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.Bucket;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.BucketAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.FilterAggregation;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiltersAggregation
extends BucketAggregation {
    private static final Logger log = LoggerFactory.getLogger(FiltersAggregation.class);
    public static final String TYPE = "filters";
    private String name;
    private Map<String, Bucket> bucketMap = new HashMap<String, Bucket>();
    private List<Bucket> bucketList = new LinkedList<Bucket>();

    public FiltersAggregation(String name, JsonObject filtersAggregation) {
        super(name, filtersAggregation);
        if (filtersAggregation.has(String.valueOf((Object)AggregationField.BUCKETS))) {
            this.parseBuckets(filtersAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)));
        }
    }

    private void parseBuckets(JsonElement buckets) {
        if (buckets.isJsonArray()) {
            int elementNumber = 0;
            for (JsonElement bucket : buckets.getAsJsonArray()) {
                this.addBucket("filter" + Integer.toString(elementNumber++), bucket.getAsJsonObject());
            }
        } else if (buckets.isJsonObject()) {
            for (Map.Entry bucket : buckets.getAsJsonObject().entrySet()) {
                this.addBucket((String)bucket.getKey(), ((JsonElement)bucket.getValue()).getAsJsonObject());
            }
        } else {
            log.debug("Skipped bucket parsing because Buckets element of JSON was neither Object nor Array.");
        }
    }

    private void addBucket(String filterName, JsonObject bucketSource) {
        FilterAggregation bucket = new FilterAggregation(filterName, bucketSource);
        this.bucketMap.put(filterName, bucket);
        this.bucketList.add(bucket);
    }

    public List<Bucket> getBuckets() {
        return this.bucketList;
    }

    public Map<String, Bucket> getBucketMap() {
        return this.bucketMap;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        FiltersAggregation rhs = (FiltersAggregation)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.bucketMap, rhs.bucketMap).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.bucketMap).toHashCode();
    }
}

