/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.io.searchbox.core.search.aggregation;

import com.google.gson.JsonObject;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.AggregationField;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.MetricAggregation;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class GeoBoundsAggregation
extends MetricAggregation {
    public static final String TYPE = "geo_bounds";
    private Double topLeftLat;
    private Double topLeftLon;
    private Double bottomRightLat;
    private Double bottomRightLon;

    public GeoBoundsAggregation(String name, JsonObject geoBoundsAggregation) {
        super(name, geoBoundsAggregation);
        if (geoBoundsAggregation.has(String.valueOf((Object)AggregationField.BOUNDS))) {
            JsonObject bounds = geoBoundsAggregation.getAsJsonObject(String.valueOf((Object)AggregationField.BOUNDS));
            JsonObject topLeft = bounds.getAsJsonObject(String.valueOf((Object)AggregationField.TOP_LEFT));
            JsonObject bottomRight = bounds.getAsJsonObject(String.valueOf((Object)AggregationField.BOTTOM_RIGHT));
            this.topLeftLat = topLeft.get(String.valueOf((Object)AggregationField.LAT)).getAsDouble();
            this.topLeftLon = topLeft.get(String.valueOf((Object)AggregationField.LON)).getAsDouble();
            this.bottomRightLat = bottomRight.get(String.valueOf((Object)AggregationField.LAT)).getAsDouble();
            this.bottomRightLon = bottomRight.get(String.valueOf((Object)AggregationField.LON)).getAsDouble();
        }
    }

    public Double getTopLeftLat() {
        return this.topLeftLat;
    }

    public Double getTopLeftLon() {
        return this.topLeftLon;
    }

    public Double getBottomRightLat() {
        return this.bottomRightLat;
    }

    public Double getBottomRightLon() {
        return this.bottomRightLon;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GeoBoundsAggregation rhs = (GeoBoundsAggregation)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.topLeftLat, (Object)rhs.topLeftLat).append((Object)this.topLeftLon, (Object)rhs.topLeftLon).append((Object)this.bottomRightLat, (Object)rhs.bottomRightLat).append((Object)this.bottomRightLon, (Object)rhs.bottomRightLon).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.bottomRightLat).append((Object)this.bottomRightLon).append((Object)this.topLeftLat).append((Object)this.topLeftLon).toHashCode();
    }
}

