/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.io.searchbox.core.search.aggregation;

import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.Aggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.AvgAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.CardinalityAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.DateHistogramAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.DateRangeAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.ExtendedStatsAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.FilterAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.FiltersAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.GeoBoundsAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.GeoDistanceAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.GeoHashGridAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.HistogramAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.Ipv4RangeAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.MaxAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.MinAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.MissingAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.PercentileRanksAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.PercentilesAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.RangeAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.ScriptedMetricAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.SignificantTermsAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.StatsAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.SumAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.TermsAggregation;
import nebula.plugin.metrics.io.searchbox.core.search.aggregation.ValueCountAggregation;

public abstract class MetricAggregation
extends Aggregation {
    public MetricAggregation(String name, JsonObject root) {
        super(name, root);
    }

    public List<Aggregation> getAggregations(Map<String, Class> nameToTypeMap) {
        ArrayList<Aggregation> aggregations = new ArrayList<Aggregation>();
        for (String nameCandidate : nameToTypeMap.keySet()) {
            if (!this.jsonRoot.has(nameCandidate)) continue;
            try {
                Class type = nameToTypeMap.get(nameCandidate);
                Constructor c = type.getConstructor(String.class, JsonObject.class);
                aggregations.add((Aggregation)c.newInstance(nameCandidate, this.jsonRoot.getAsJsonObject(nameCandidate)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return aggregations;
    }

    public <T extends Aggregation> T getAggregation(String aggName, Class<T> aggType) {
        if (this.jsonRoot.has(aggName)) {
            try {
                Constructor<T> c = aggType.getConstructor(String.class, JsonObject.class);
                return (T)((Aggregation)c.newInstance(aggName, this.jsonRoot.getAsJsonObject(aggName)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public AvgAggregation getAvgAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new AvgAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public CardinalityAggregation getCardinalityAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new CardinalityAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public DateHistogramAggregation getDateHistogramAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new DateHistogramAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public DateRangeAggregation getDateRangeAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new DateRangeAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public ExtendedStatsAggregation getExtendedStatsAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new ExtendedStatsAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public FilterAggregation getFilterAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new FilterAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public FiltersAggregation getFiltersAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new FiltersAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public GeoBoundsAggregation getGeoBoundsAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new GeoBoundsAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public GeoDistanceAggregation getGeoDistanceAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new GeoDistanceAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public GeoHashGridAggregation getGeohashGridAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new GeoHashGridAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public HistogramAggregation getHistogramAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new HistogramAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public Ipv4RangeAggregation getIpv4RangeAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new Ipv4RangeAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public MaxAggregation getMaxAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new MaxAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public MinAggregation getMinAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new MinAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public MissingAggregation getMissingAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new MissingAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public PercentileRanksAggregation getPercentileRanksAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new PercentileRanksAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public PercentilesAggregation getPercentilesAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new PercentilesAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public RangeAggregation getRangeAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new RangeAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public ScriptedMetricAggregation getScriptedMetricAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new ScriptedMetricAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public SignificantTermsAggregation getSignificantTermsAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new SignificantTermsAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public StatsAggregation getStatsAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new StatsAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public SumAggregation getSumAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new SumAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public TermsAggregation getTermsAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new TermsAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }

    public ValueCountAggregation getValueCountAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new ValueCountAggregation(aggName, this.jsonRoot.getAsJsonObject(aggName)) : null;
    }
}

