/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.io.searchbox.core.search.facet;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import nebula.plugin.metrics.io.searchbox.core.search.facet.Facet;

public class HistogramFacet
extends Facet {
    public static final String TYPE = "histogram";
    private List<Histogram> histograms;

    public HistogramFacet(String name, JsonObject histogramFacet) {
        this.name = name;
        this.histograms = new ArrayList<Histogram>();
        for (JsonElement termv : histogramFacet.get("entries").getAsJsonArray()) {
            JsonObject term = (JsonObject)termv;
            Histogram histogram = new Histogram(term.get("key").getAsLong(), term.get("count").getAsLong());
            this.histograms.add(histogram);
        }
    }

    public List<Histogram> getHistograms() {
        return this.histograms;
    }

    public class Histogram {
        private Long key;
        private Long count;

        Histogram(Long key, Long count) {
            this.key = key;
            this.count = count;
        }

        public Long getKey() {
            return this.key;
        }

        public Long getCount() {
            return this.count;
        }
    }
}

