/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.io.searchbox.core.search.facet;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import nebula.plugin.metrics.io.searchbox.core.search.facet.Facet;

public class RangeFacet
extends Facet {
    public static final String TYPE = "range";
    private List<Range> ranges;

    public RangeFacet(String name, JsonObject rangeFacet) {
        this.name = name;
        this.ranges = new ArrayList<Range>();
        for (JsonElement termv : rangeFacet.get("ranges").getAsJsonArray()) {
            JsonObject term = (JsonObject)termv;
            Range range = new Range(term.has("from") ? Double.valueOf(term.get("from").getAsDouble()) : null, term.has("to") ? Double.valueOf(term.get("to").getAsDouble()) : null, term.has("count") ? Long.valueOf(term.get("count").getAsLong()) : null, term.has("total_count") ? Long.valueOf(term.get("total_count").getAsLong()) : null, term.has("total") ? Double.valueOf(term.get("total").getAsDouble()) : null, term.has("min") ? Double.valueOf(term.get("min").getAsDouble()) : null, term.has("max") ? Double.valueOf(term.get("max").getAsDouble()) : null, term.has("mean") ? Double.valueOf(term.get("mean").getAsDouble()) : null);
            this.ranges.add(range);
        }
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public class Range {
        private Double from = Double.NEGATIVE_INFINITY;
        private Double to = Double.POSITIVE_INFINITY;
        private Long count;
        private Long totalCount;
        private Double total;
        private Double min = Double.POSITIVE_INFINITY;
        private Double max = Double.NEGATIVE_INFINITY;
        private Double mean;

        public Range(Double from, Double to, Long count, Long totalCount, Double total, Double min, Double max, Double mean) {
            this.count = count;
            this.from = from;
            this.to = to;
            this.totalCount = totalCount;
            this.total = total;
            this.min = min;
            this.max = max;
            this.mean = mean;
        }

        public Double getFrom() {
            return this.from;
        }

        public Double getTo() {
            return this.to;
        }

        public Long getCount() {
            return this.count;
        }

        public Long getTotalCount() {
            return this.totalCount;
        }

        public Double getTotal() {
            return this.total;
        }

        public Double getMin() {
            return this.min;
        }

        public Double getMax() {
            return this.max;
        }

        public Double getMean() {
            return this.mean;
        }
    }
}

