/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.io.searchbox.indices.aliases;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nebula.plugin.metrics.io.searchbox.indices.aliases.AliasMapping;

public abstract class AbstractAliasMappingBuilder<T extends AliasMapping, K> {
    protected Map<String, Object> filter;
    protected String alias;
    protected List<String> indices = new LinkedList<String>();
    protected List<String> searchRouting = new LinkedList<String>();
    protected List<String> indexRouting = new LinkedList<String>();

    public AbstractAliasMappingBuilder(Collection<String> indices, String alias) {
        this.indices.addAll(indices);
        this.alias = alias;
    }

    public AbstractAliasMappingBuilder(String index, String alias) {
        this.indices.add(index);
        this.alias = alias;
    }

    public K addIndex(String index) {
        this.indices.add(index);
        return (K)this;
    }

    public K addIndex(Collection<String> indices) {
        this.indices.addAll(indices);
        return (K)this;
    }

    public K setFilter(Map<String, Object> source) {
        this.filter = source;
        return (K)this;
    }

    public K addRouting(String routing) {
        this.indexRouting.add(routing);
        this.searchRouting.add(routing);
        return (K)this;
    }

    public K addRouting(List<String> routings) {
        this.indexRouting.addAll(routings);
        this.searchRouting.addAll(routings);
        return (K)this;
    }

    public K addSearchRouting(String searchRouting) {
        this.searchRouting.add(searchRouting);
        return (K)this;
    }

    public K addSearchRouting(List<String> searchRoutings) {
        this.searchRouting.addAll(searchRoutings);
        return (K)this;
    }

    public K addIndexRouting(String indexRouting) {
        this.indexRouting.add(indexRouting);
        return (K)this;
    }

    public K addIndexRouting(List<String> indexRoutings) {
        this.indexRouting.addAll(indexRoutings);
        return (K)this;
    }

    public abstract T build();
}

