/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.model;

import java.util.ArrayList;
import java.util.List;
import nebula.plugin.metrics.com.google.common.base.Preconditions;
import nebula.plugin.metrics.com.google.common.collect.ImmutableList;
import nebula.plugin.metrics.model.Event;
import nebula.plugin.metrics.model.Info;
import nebula.plugin.metrics.model.Project;
import nebula.plugin.metrics.model.Result;
import nebula.plugin.metrics.model.Task;
import nebula.plugin.metrics.model.Test;
import org.joda.time.DateTime;

public class Build {
    private Project project;
    private final List<Event> events = new ArrayList<Event>();
    private final List<Task> tasks = new ArrayList<Task>();
    private final List<Test> tests = new ArrayList<Test>();
    private Info info;
    private Result result = Result.unknown();
    private long startTime;
    private long elapsedTime;

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = Preconditions.checkNotNull(project);
    }

    public List<Event> getEvents() {
        return ImmutableList.copyOf(this.events);
    }

    public void addEvent(Event event) {
        this.events.add(Preconditions.checkNotNull(event));
    }

    public int getEventsCount() {
        return this.events.size();
    }

    public long getEventsElapsedTime() {
        long elapsedTime = 0L;
        for (Event event : this.events) {
            elapsedTime += event.getElapsedTime();
        }
        return elapsedTime;
    }

    public List<Task> getTasks() {
        return ImmutableList.copyOf(this.tasks);
    }

    public void addTask(Task task) {
        this.tasks.add(Preconditions.checkNotNull(task));
    }

    public int getTaskCount() {
        return this.tasks.size();
    }

    public long getTasksElapsedTime() {
        long elapsedTime = 0L;
        for (Task task : this.tasks) {
            elapsedTime += task.getElapsedTime();
        }
        return elapsedTime;
    }

    public List<Test> getTests() {
        return ImmutableList.copyOf(this.tests);
    }

    public void addTest(Test test) {
        this.tests.add(Preconditions.checkNotNull(test));
    }

    public int getTestCount() {
        return this.tests.size();
    }

    public long getTestElapsedTime() {
        long elapsedTime = 0L;
        for (Test test : this.tests) {
            elapsedTime += test.getElapsedTime();
        }
        return elapsedTime;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = Preconditions.checkNotNull(info);
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = Preconditions.checkNotNull(result);
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public DateTime getStartTime() {
        return new DateTime(this.startTime);
    }

    public DateTime getFinishedTime() {
        return new DateTime(this.startTime + this.elapsedTime);
    }

    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public Long getElapsedTime() {
        return this.elapsedTime;
    }
}

