/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.model;

import java.beans.ConstructorProperties;
import java.io.File;
import java.util.List;
import java.util.Set;
import nebula.plugin.metrics.model.KeyValue;
import org.gradle.StartParameter;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.invocation.Gradle;

public final class GradleParameters {
    private final List<TaskExecutionRequest> taskRequests;
    private final Set<String> excludedTaskNames;
    private final boolean buildProjectDependencies;
    private final File currentDir;
    private final File projectDir;
    private final boolean searchUpwards;
    private final List<KeyValue> projectProperties;
    private final File gradleUserHomeDir;
    private final File settingsFile;
    private final boolean useEmptySettings;
    private final File buildFile;
    private final List<File> initScripts;
    private final boolean dryRun;
    private final boolean rerunTasks;
    private final boolean profile;
    private final boolean continueOnFailure;
    private final boolean offline;
    private final File projectCacheDir;
    private final boolean refreshDependencies;
    private final boolean recompileScripts;
    private final int parallelThreadCount;
    private final boolean configureOnDemand;

    public static GradleParameters fromGradle(Gradle gradle) {
        StartParameter start = gradle.getStartParameter();
        List<KeyValue> projectProperties = KeyValue.mapToKeyValueList(start.getProjectProperties());
        return new GradleParameters(start.getTaskRequests(), start.getExcludedTaskNames(), start.isBuildProjectDependencies(), start.getCurrentDir(), start.getProjectDir(), start.isSearchUpwards(), projectProperties, start.getGradleUserHomeDir(), start.getSettingsFile(), start.isUseEmptySettings(), start.getBuildFile(), start.getInitScripts(), start.isDryRun(), start.isRerunTasks(), start.isProfile(), start.isContinueOnFailure(), start.isOffline(), start.getProjectCacheDir(), start.isRefreshDependencies(), start.isRecompileScripts(), start.getParallelThreadCount(), start.isConfigureOnDemand());
    }

    @ConstructorProperties(value={"taskRequests", "excludedTaskNames", "buildProjectDependencies", "currentDir", "projectDir", "searchUpwards", "projectProperties", "gradleUserHomeDir", "settingsFile", "useEmptySettings", "buildFile", "initScripts", "dryRun", "rerunTasks", "profile", "continueOnFailure", "offline", "projectCacheDir", "refreshDependencies", "recompileScripts", "parallelThreadCount", "configureOnDemand"})
    public GradleParameters(List<TaskExecutionRequest> taskRequests, Set<String> excludedTaskNames, boolean buildProjectDependencies, File currentDir, File projectDir, boolean searchUpwards, List<KeyValue> projectProperties, File gradleUserHomeDir, File settingsFile, boolean useEmptySettings, File buildFile, List<File> initScripts, boolean dryRun, boolean rerunTasks, boolean profile, boolean continueOnFailure, boolean offline, File projectCacheDir, boolean refreshDependencies, boolean recompileScripts, int parallelThreadCount, boolean configureOnDemand) {
        this.taskRequests = taskRequests;
        this.excludedTaskNames = excludedTaskNames;
        this.buildProjectDependencies = buildProjectDependencies;
        this.currentDir = currentDir;
        this.projectDir = projectDir;
        this.searchUpwards = searchUpwards;
        this.projectProperties = projectProperties;
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.settingsFile = settingsFile;
        this.useEmptySettings = useEmptySettings;
        this.buildFile = buildFile;
        this.initScripts = initScripts;
        this.dryRun = dryRun;
        this.rerunTasks = rerunTasks;
        this.profile = profile;
        this.continueOnFailure = continueOnFailure;
        this.offline = offline;
        this.projectCacheDir = projectCacheDir;
        this.refreshDependencies = refreshDependencies;
        this.recompileScripts = recompileScripts;
        this.parallelThreadCount = parallelThreadCount;
        this.configureOnDemand = configureOnDemand;
    }

    public List<TaskExecutionRequest> getTaskRequests() {
        return this.taskRequests;
    }

    public Set<String> getExcludedTaskNames() {
        return this.excludedTaskNames;
    }

    public boolean isBuildProjectDependencies() {
        return this.buildProjectDependencies;
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public boolean isSearchUpwards() {
        return this.searchUpwards;
    }

    public List<KeyValue> getProjectProperties() {
        return this.projectProperties;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public File getSettingsFile() {
        return this.settingsFile;
    }

    public boolean isUseEmptySettings() {
        return this.useEmptySettings;
    }

    public File getBuildFile() {
        return this.buildFile;
    }

    public List<File> getInitScripts() {
        return this.initScripts;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isRerunTasks() {
        return this.rerunTasks;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public boolean isContinueOnFailure() {
        return this.continueOnFailure;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public File getProjectCacheDir() {
        return this.projectCacheDir;
    }

    public boolean isRefreshDependencies() {
        return this.refreshDependencies;
    }

    public boolean isRecompileScripts() {
        return this.recompileScripts;
    }

    public int getParallelThreadCount() {
        return this.parallelThreadCount;
    }

    public boolean isConfigureOnDemand() {
        return this.configureOnDemand;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleParameters)) {
            return false;
        }
        GradleParameters other = (GradleParameters)o;
        List<TaskExecutionRequest> this$taskRequests = this.getTaskRequests();
        List<TaskExecutionRequest> other$taskRequests = other.getTaskRequests();
        if (this$taskRequests == null ? other$taskRequests != null : !((Object)this$taskRequests).equals(other$taskRequests)) {
            return false;
        }
        Set<String> this$excludedTaskNames = this.getExcludedTaskNames();
        Set<String> other$excludedTaskNames = other.getExcludedTaskNames();
        if (this$excludedTaskNames == null ? other$excludedTaskNames != null : !((Object)this$excludedTaskNames).equals(other$excludedTaskNames)) {
            return false;
        }
        if (this.isBuildProjectDependencies() != other.isBuildProjectDependencies()) {
            return false;
        }
        File this$currentDir = this.getCurrentDir();
        File other$currentDir = other.getCurrentDir();
        if (this$currentDir == null ? other$currentDir != null : !((Object)this$currentDir).equals(other$currentDir)) {
            return false;
        }
        File this$projectDir = this.getProjectDir();
        File other$projectDir = other.getProjectDir();
        if (this$projectDir == null ? other$projectDir != null : !((Object)this$projectDir).equals(other$projectDir)) {
            return false;
        }
        if (this.isSearchUpwards() != other.isSearchUpwards()) {
            return false;
        }
        List<KeyValue> this$projectProperties = this.getProjectProperties();
        List<KeyValue> other$projectProperties = other.getProjectProperties();
        if (this$projectProperties == null ? other$projectProperties != null : !((Object)this$projectProperties).equals(other$projectProperties)) {
            return false;
        }
        File this$gradleUserHomeDir = this.getGradleUserHomeDir();
        File other$gradleUserHomeDir = other.getGradleUserHomeDir();
        if (this$gradleUserHomeDir == null ? other$gradleUserHomeDir != null : !((Object)this$gradleUserHomeDir).equals(other$gradleUserHomeDir)) {
            return false;
        }
        File this$settingsFile = this.getSettingsFile();
        File other$settingsFile = other.getSettingsFile();
        if (this$settingsFile == null ? other$settingsFile != null : !((Object)this$settingsFile).equals(other$settingsFile)) {
            return false;
        }
        if (this.isUseEmptySettings() != other.isUseEmptySettings()) {
            return false;
        }
        File this$buildFile = this.getBuildFile();
        File other$buildFile = other.getBuildFile();
        if (this$buildFile == null ? other$buildFile != null : !((Object)this$buildFile).equals(other$buildFile)) {
            return false;
        }
        List<File> this$initScripts = this.getInitScripts();
        List<File> other$initScripts = other.getInitScripts();
        if (this$initScripts == null ? other$initScripts != null : !((Object)this$initScripts).equals(other$initScripts)) {
            return false;
        }
        if (this.isDryRun() != other.isDryRun()) {
            return false;
        }
        if (this.isRerunTasks() != other.isRerunTasks()) {
            return false;
        }
        if (this.isProfile() != other.isProfile()) {
            return false;
        }
        if (this.isContinueOnFailure() != other.isContinueOnFailure()) {
            return false;
        }
        if (this.isOffline() != other.isOffline()) {
            return false;
        }
        File this$projectCacheDir = this.getProjectCacheDir();
        File other$projectCacheDir = other.getProjectCacheDir();
        if (this$projectCacheDir == null ? other$projectCacheDir != null : !((Object)this$projectCacheDir).equals(other$projectCacheDir)) {
            return false;
        }
        if (this.isRefreshDependencies() != other.isRefreshDependencies()) {
            return false;
        }
        if (this.isRecompileScripts() != other.isRecompileScripts()) {
            return false;
        }
        if (this.getParallelThreadCount() != other.getParallelThreadCount()) {
            return false;
        }
        return this.isConfigureOnDemand() == other.isConfigureOnDemand();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TaskExecutionRequest> $taskRequests = this.getTaskRequests();
        result = result * 59 + ($taskRequests == null ? 43 : ((Object)$taskRequests).hashCode());
        Set<String> $excludedTaskNames = this.getExcludedTaskNames();
        result = result * 59 + ($excludedTaskNames == null ? 43 : ((Object)$excludedTaskNames).hashCode());
        result = result * 59 + (this.isBuildProjectDependencies() ? 79 : 97);
        File $currentDir = this.getCurrentDir();
        result = result * 59 + ($currentDir == null ? 43 : ((Object)$currentDir).hashCode());
        File $projectDir = this.getProjectDir();
        result = result * 59 + ($projectDir == null ? 43 : ((Object)$projectDir).hashCode());
        result = result * 59 + (this.isSearchUpwards() ? 79 : 97);
        List<KeyValue> $projectProperties = this.getProjectProperties();
        result = result * 59 + ($projectProperties == null ? 43 : ((Object)$projectProperties).hashCode());
        File $gradleUserHomeDir = this.getGradleUserHomeDir();
        result = result * 59 + ($gradleUserHomeDir == null ? 43 : ((Object)$gradleUserHomeDir).hashCode());
        File $settingsFile = this.getSettingsFile();
        result = result * 59 + ($settingsFile == null ? 43 : ((Object)$settingsFile).hashCode());
        result = result * 59 + (this.isUseEmptySettings() ? 79 : 97);
        File $buildFile = this.getBuildFile();
        result = result * 59 + ($buildFile == null ? 43 : ((Object)$buildFile).hashCode());
        List<File> $initScripts = this.getInitScripts();
        result = result * 59 + ($initScripts == null ? 43 : ((Object)$initScripts).hashCode());
        result = result * 59 + (this.isDryRun() ? 79 : 97);
        result = result * 59 + (this.isRerunTasks() ? 79 : 97);
        result = result * 59 + (this.isProfile() ? 79 : 97);
        result = result * 59 + (this.isContinueOnFailure() ? 79 : 97);
        result = result * 59 + (this.isOffline() ? 79 : 97);
        File $projectCacheDir = this.getProjectCacheDir();
        result = result * 59 + ($projectCacheDir == null ? 43 : ((Object)$projectCacheDir).hashCode());
        result = result * 59 + (this.isRefreshDependencies() ? 79 : 97);
        result = result * 59 + (this.isRecompileScripts() ? 79 : 97);
        result = result * 59 + this.getParallelThreadCount();
        result = result * 59 + (this.isConfigureOnDemand() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "GradleParameters(taskRequests=" + this.getTaskRequests() + ", excludedTaskNames=" + this.getExcludedTaskNames() + ", buildProjectDependencies=" + this.isBuildProjectDependencies() + ", currentDir=" + this.getCurrentDir() + ", projectDir=" + this.getProjectDir() + ", searchUpwards=" + this.isSearchUpwards() + ", projectProperties=" + this.getProjectProperties() + ", gradleUserHomeDir=" + this.getGradleUserHomeDir() + ", settingsFile=" + this.getSettingsFile() + ", useEmptySettings=" + this.isUseEmptySettings() + ", buildFile=" + this.getBuildFile() + ", initScripts=" + this.getInitScripts() + ", dryRun=" + this.isDryRun() + ", rerunTasks=" + this.isRerunTasks() + ", profile=" + this.isProfile() + ", continueOnFailure=" + this.isContinueOnFailure() + ", offline=" + this.isOffline() + ", projectCacheDir=" + this.getProjectCacheDir() + ", refreshDependencies=" + this.isRefreshDependencies() + ", recompileScripts=" + this.isRecompileScripts() + ", parallelThreadCount=" + this.getParallelThreadCount() + ", configureOnDemand=" + this.isConfigureOnDemand() + ")";
    }
}

