/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.model;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import nebula.plugin.metrics.model.Gradle;
import nebula.plugin.metrics.model.GradleParameters;
import nebula.plugin.metrics.model.Tool;

public final class GradleToolContainer
implements Tool {
    @NonNull
    private final Gradle gradle;

    @Override
    public String getType() {
        return "gradle";
    }

    public static GradleToolContainer fromGradle(org.gradle.api.invocation.Gradle gradle) {
        GradleParameters parameters = GradleParameters.fromGradle(gradle);
        Gradle gradleModel = new Gradle(gradle.getGradleVersion(), parameters);
        return new GradleToolContainer(gradleModel);
    }

    @ConstructorProperties(value={"gradle"})
    public GradleToolContainer(@NonNull Gradle gradle) {
        if (gradle == null) {
            throw new NullPointerException("gradle");
        }
        this.gradle = gradle;
    }

    @NonNull
    public Gradle getGradle() {
        return this.gradle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleToolContainer)) {
            return false;
        }
        GradleToolContainer other = (GradleToolContainer)o;
        Gradle this$gradle = this.getGradle();
        Gradle other$gradle = other.getGradle();
        return !(this$gradle == null ? other$gradle != null : !((Object)this$gradle).equals(other$gradle));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Gradle $gradle = this.getGradle();
        result = result * 59 + ($gradle == null ? 43 : ((Object)$gradle).hashCode());
        return result;
    }

    public String toString() {
        return "GradleToolContainer(gradle=" + this.getGradle() + ")";
    }
}

