/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import nebula.plugin.metrics.model.GradleToolContainer;
import nebula.plugin.metrics.model.KeyValue;
import nebula.plugin.metrics.model.Tool;
import nebula.plugin.metrics.model.UnknownTool;

@JsonPropertyOrder(value={"build", "scm", "ci", "environmentVariables", "systemProperties"})
public final class Info {
    @NonNull
    private final Tool build;
    @NonNull
    private final Tool scm;
    @NonNull
    private final Tool ci;
    @NonNull
    private final List<KeyValue> environmentVariables;
    @NonNull
    private final List<KeyValue> systemProperties;

    public static Info create(GradleToolContainer tool) {
        return Info.create(tool, new UnknownTool(), new UnknownTool());
    }

    public static Info create(Tool tool, Tool scm, Tool ci) {
        return Info.create(tool, scm, ci, System.getenv(), new HashMap<Object, Object>(System.getProperties()));
    }

    public static Info create(Tool tool, Tool scm, Tool ci, Map<String, String> env, Map<String, String> systemProperties) {
        List<KeyValue> envList = KeyValue.mapToKeyValueList(env);
        List<KeyValue> systemPropertiesList = KeyValue.mapToKeyValueList(systemProperties);
        return new Info(tool, scm, ci, envList, systemPropertiesList);
    }

    public static Info sanitize(Info info, List<String> sanitizedProperties) {
        List<KeyValue> systemProperties = Info.sanitizeKeyValues(info.getSystemProperties(), sanitizedProperties);
        List<KeyValue> environmentVariables = Info.sanitizeKeyValues(info.getEnvironmentVariables(), sanitizedProperties);
        return new Info(info.getBuild(), info.getScm(), info.getCi(), systemProperties, environmentVariables);
    }

    private static List<KeyValue> sanitizeKeyValues(List<KeyValue> keyValues, List<String> sanitizedProperties) {
        ArrayList<KeyValue> sanitizedKeyValues = new ArrayList<KeyValue>();
        for (KeyValue keyValue : keyValues) {
            if (sanitizedProperties.contains(keyValue.getKey())) {
                sanitizedKeyValues.add(new KeyValue(keyValue.getKey(), "SANITIZED"));
                continue;
            }
            sanitizedKeyValues.add(keyValue);
        }
        return sanitizedKeyValues;
    }

    public String getJavaVersion() {
        for (KeyValue systemProperty : this.systemProperties) {
            if (!systemProperty.getKey().equals("java.version")) continue;
            return systemProperty.getValue();
        }
        return "unknown";
    }

    @ConstructorProperties(value={"build", "scm", "ci", "environmentVariables", "systemProperties"})
    public Info(@NonNull Tool build, @NonNull Tool scm, @NonNull Tool ci, @NonNull List<KeyValue> environmentVariables, @NonNull List<KeyValue> systemProperties) {
        if (build == null) {
            throw new NullPointerException("build");
        }
        if (scm == null) {
            throw new NullPointerException("scm");
        }
        if (ci == null) {
            throw new NullPointerException("ci");
        }
        if (environmentVariables == null) {
            throw new NullPointerException("environmentVariables");
        }
        if (systemProperties == null) {
            throw new NullPointerException("systemProperties");
        }
        this.build = build;
        this.scm = scm;
        this.ci = ci;
        this.environmentVariables = environmentVariables;
        this.systemProperties = systemProperties;
    }

    @NonNull
    public Tool getBuild() {
        return this.build;
    }

    @NonNull
    public Tool getScm() {
        return this.scm;
    }

    @NonNull
    public Tool getCi() {
        return this.ci;
    }

    @NonNull
    public List<KeyValue> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @NonNull
    public List<KeyValue> getSystemProperties() {
        return this.systemProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Info)) {
            return false;
        }
        Info other = (Info)o;
        Tool this$build = this.getBuild();
        Tool other$build = other.getBuild();
        if (this$build == null ? other$build != null : !this$build.equals(other$build)) {
            return false;
        }
        Tool this$scm = this.getScm();
        Tool other$scm = other.getScm();
        if (this$scm == null ? other$scm != null : !this$scm.equals(other$scm)) {
            return false;
        }
        Tool this$ci = this.getCi();
        Tool other$ci = other.getCi();
        if (this$ci == null ? other$ci != null : !this$ci.equals(other$ci)) {
            return false;
        }
        List<KeyValue> this$environmentVariables = this.getEnvironmentVariables();
        List<KeyValue> other$environmentVariables = other.getEnvironmentVariables();
        if (this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables)) {
            return false;
        }
        List<KeyValue> this$systemProperties = this.getSystemProperties();
        List<KeyValue> other$systemProperties = other.getSystemProperties();
        return !(this$systemProperties == null ? other$systemProperties != null : !((Object)this$systemProperties).equals(other$systemProperties));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Tool $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : $build.hashCode());
        Tool $scm = this.getScm();
        result = result * 59 + ($scm == null ? 43 : $scm.hashCode());
        Tool $ci = this.getCi();
        result = result * 59 + ($ci == null ? 43 : $ci.hashCode());
        List<KeyValue> $environmentVariables = this.getEnvironmentVariables();
        result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
        List<KeyValue> $systemProperties = this.getSystemProperties();
        result = result * 59 + ($systemProperties == null ? 43 : ((Object)$systemProperties).hashCode());
        return result;
    }

    public String toString() {
        return "Info(build=" + this.getBuild() + ", scm=" + this.getScm() + ", ci=" + this.getCi() + ", environmentVariables=" + this.getEnvironmentVariables() + ", systemProperties=" + this.getSystemProperties() + ")";
    }
}

