/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.model;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import nebula.plugin.metrics.com.google.common.collect.Lists;

public final class KeyValue {
    @NonNull
    private final String key;
    @NonNull
    private final String value;

    static List<KeyValue> mapToKeyValueList(Map<String, String> map) {
        Set<Map.Entry<String, String>> entries = map.entrySet();
        ArrayList<KeyValue> keyValues = Lists.newArrayListWithCapacity(entries.size());
        for (Map.Entry<String, String> entry : entries) {
            keyValues.add(KeyValue.entryToKeyValue(entry));
        }
        return keyValues;
    }

    static KeyValue entryToKeyValue(Map.Entry<String, String> entry) {
        String key = String.valueOf(entry.getKey());
        String value = String.valueOf(entry.getValue());
        return new KeyValue(key, value);
    }

    @ConstructorProperties(value={"key", "value"})
    public KeyValue(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.key = key;
        this.value = value;
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyValue)) {
            return false;
        }
        KeyValue other = (KeyValue)o;
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "KeyValue(key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }
}

