/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.model;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import nebula.plugin.metrics.com.google.common.base.Preconditions;
import nebula.plugin.metrics.com.google.common.base.Throwables;

public final class Result {
    @NonNull
    private final ResultStatus status;
    private final List<String> failures;

    public static Result unknown() {
        return Result.create(ResultStatus.UNKNOWN);
    }

    public static Result success() {
        return Result.create(ResultStatus.SUCCESS);
    }

    public static Result failure(Throwable throwable) {
        return Result.failure(Arrays.asList(throwable));
    }

    public static Result failure(Iterable<? extends Throwable> failures) {
        Preconditions.checkNotNull(failures);
        ArrayList<String> stringFailures = new ArrayList<String>();
        for (Throwable throwable : failures) {
            stringFailures.add(Throwables.getStackTraceAsString(throwable));
        }
        return new Result(ResultStatus.FAILURE, stringFailures);
    }

    public static Result skipped() {
        return Result.create(ResultStatus.SKIPPED);
    }

    private static Result create(ResultStatus status) {
        return new Result(status, null);
    }

    @ConstructorProperties(value={"status", "failures"})
    public Result(@NonNull ResultStatus status, List<String> failures) {
        if (status == null) {
            throw new NullPointerException("status");
        }
        this.status = status;
        this.failures = failures;
    }

    @NonNull
    public ResultStatus getStatus() {
        return this.status;
    }

    public List<String> getFailures() {
        return this.failures;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        ResultStatus this$status = this.getStatus();
        ResultStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        List<String> this$failures = this.getFailures();
        List<String> other$failures = other.getFailures();
        return !(this$failures == null ? other$failures != null : !((Object)this$failures).equals(other$failures));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResultStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        List<String> $failures = this.getFailures();
        result = result * 59 + ($failures == null ? 43 : ((Object)$failures).hashCode());
        return result;
    }

    public String toString() {
        return "Result(status=" + (Object)((Object)this.getStatus()) + ", failures=" + this.getFailures() + ")";
    }

    public static enum ResultStatus {
        UNKNOWN,
        SUCCESS,
        FAILURE,
        SKIPPED;

    }
}

