/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.model;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import nebula.plugin.metrics.model.Result;
import org.joda.time.DateTime;

public final class Task {
    @NonNull
    private final String description;
    @NonNull
    private final Result result;
    @NonNull
    private final DateTime startTime;
    private final long elapsedTime;

    @ConstructorProperties(value={"description", "result", "startTime", "elapsedTime"})
    public Task(@NonNull String description, @NonNull Result result, @NonNull DateTime startTime, long elapsedTime) {
        if (description == null) {
            throw new NullPointerException("description");
        }
        if (result == null) {
            throw new NullPointerException("result");
        }
        if (startTime == null) {
            throw new NullPointerException("startTime");
        }
        this.description = description;
        this.result = result;
        this.startTime = startTime;
        this.elapsedTime = elapsedTime;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public Result getResult() {
        return this.result;
    }

    @NonNull
    public DateTime getStartTime() {
        return this.startTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Result this$result = this.getResult();
        Result other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        DateTime this$startTime = this.getStartTime();
        DateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        return this.getElapsedTime() == other.getElapsedTime();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Result $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        DateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        long $elapsedTime = this.getElapsedTime();
        result = result * 59 + (int)($elapsedTime >>> 32 ^ $elapsedTime);
        return result;
    }

    public String toString() {
        return "Task(description=" + this.getDescription() + ", result=" + this.getResult() + ", startTime=" + this.getStartTime() + ", elapsedTime=" + this.getElapsedTime() + ")";
    }
}

